/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.File;
import net.sf.retrotranslator.transformer.Level;
import net.sf.retrotranslator.transformer.Message;
import net.sf.retrotranslator.transformer.MessageLogger;

class SystemLogger
implements MessageLogger {
    private MessageLogger logger;
    private boolean verbose;
    private File fileLocation;
    private String fileName;
    private boolean reliable = true;

    public SystemLogger(MessageLogger logger, boolean verbose) {
        this.logger = logger;
        this.verbose = verbose;
    }

    public void setFile(File fileLocation, String fileName) {
        this.fileLocation = fileLocation;
        this.fileName = fileName;
    }

    public void logForFile(Level level, String text) {
        this.log(new Message(level, text, this.fileLocation, this.fileName));
    }

    public void log(Message message) {
        if (message.getLevel() != Level.VERBOSE || this.verbose) {
            if (message.getLevel().isCritical()) {
                this.reliable = false;
            }
            this.logger.log(message);
        }
    }

    public boolean isReliable() {
        return this.reliable;
    }
}

