/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.retrotranslator.runtime.asm.FieldVisitor;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.impl.EmptyVisitor;
import net.sf.retrotranslator.transformer.ClassReplacement;
import net.sf.retrotranslator.transformer.ConstructorReplacement;
import net.sf.retrotranslator.transformer.MemberKey;
import net.sf.retrotranslator.transformer.MemberReplacement;
import net.sf.retrotranslator.transformer.NameTranslator;
import net.sf.retrotranslator.transformer.ReplacementLocator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SmartReplacementVisitor
extends EmptyVisitor {
    private final ReplacementLocator locator;
    private final NameTranslator translator;
    private boolean enabled;
    private Set<String> constructorDescriptors = new HashSet<String>();
    private Map<MemberKey, MemberReplacement> fieldReplacements = new HashMap<MemberKey, MemberReplacement>();
    private Map<MemberKey, MemberReplacement> methodReplacements = new HashMap<MemberKey, MemberReplacement>();
    private Map<String, MemberReplacement> converterReplacements = new HashMap<String, MemberReplacement>();
    private Map<String, ConstructorReplacement> constructorReplacements = new HashMap<String, ConstructorReplacement>();

    public SmartReplacementVisitor(ReplacementLocator locator) {
        this.locator = locator;
        this.translator = locator.getTranslator();
    }

    public void addInheritedMembers(ClassReplacement replacement) {
        if (this.enabled) {
            this.cleanConstructorReplacements();
            this.cleanConverterReplacements();
            this.copyIfAbsent(this.fieldReplacements, replacement.getFieldReplacements());
            this.copyIfAbsent(this.methodReplacements, replacement.getMethodReplacements());
            this.copyIfAbsent(this.converterReplacements, replacement.getConverterReplacements());
            this.copyIfAbsent(this.constructorReplacements, replacement.getConstructorReplacements());
        }
    }

    private void cleanConstructorReplacements() {
        Iterator<ConstructorReplacement> iterator = this.constructorReplacements.values().iterator();
        while (iterator.hasNext()) {
            ConstructorReplacement replacement = iterator.next();
            if (this.constructorDescriptors.contains(replacement.getConstructorDesc())) continue;
            iterator.remove();
        }
    }

    private void cleanConverterReplacements() {
        Iterator<MemberReplacement> iterator = this.converterReplacements.values().iterator();
        while (iterator.hasNext()) {
            MemberReplacement replacement = iterator.next();
            if (this.constructorDescriptors.contains(ClassReplacement.getConstructorDesc(replacement))) continue;
            iterator.remove();
        }
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (superName != null) {
            this.saveInheritedMembers(superName);
        }
        if (interfaces != null) {
            for (String interfaceName : interfaces) {
                this.saveInheritedMembers(interfaceName);
            }
        }
    }

    private void saveInheritedMembers(String className) {
        ClassReplacement replacement = this.locator.getReplacement(this.locator.getUniqueTypeName(className));
        if (replacement == null) {
            return;
        }
        this.enabled = true;
        this.copyIfAbsent(replacement.getFieldReplacements(), this.fieldReplacements);
        this.copyIfAbsent(replacement.getMethodReplacements(), this.methodReplacements);
        this.copyIfAbsent(replacement.getConverterReplacements(), this.converterReplacements);
        this.copyIfAbsent(replacement.getConstructorReplacements(), this.constructorReplacements);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.enabled && (access & 8) != 0) {
            MemberKey key = new MemberKey(true, this.translator.identifier(name), this.translator.typeDescriptor(desc));
            this.fieldReplacements.remove(key);
        }
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.enabled) {
            String descriptor = this.translator.methodDescriptor(desc);
            if (name.equals("<init>")) {
                this.constructorDescriptors.add(descriptor);
                this.converterReplacements.remove(descriptor);
                this.constructorReplacements.remove(descriptor);
            } else {
                boolean statical = (access & 8) != 0;
                this.methodReplacements.remove(new MemberKey(statical, this.translator.identifier(name), descriptor));
            }
        }
        return null;
    }

    private <K, V> void copyIfAbsent(Map<K, V> source, Map<K, V> destination) {
        for (Map.Entry<K, V> entry : source.entrySet()) {
            if (destination.containsKey(entry.getKey())) continue;
            destination.put(entry.getKey(), entry.getValue());
        }
    }
}

