/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.LinkedHashSet;
import java.util.Set;
import net.sf.retrotranslator.runtime.asm.ClassAdapter;
import net.sf.retrotranslator.runtime.asm.ClassReader;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.impl.EmptyVisitor;
import net.sf.retrotranslator.transformer.NameTranslator;
import net.sf.retrotranslator.transformer.ReplacementLocator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MirandaMethodsVisitor
extends ClassAdapter {
    private final ReplacementLocator locator;
    private final NameTranslator translator;

    public MirandaMethodsVisitor(ClassVisitor visitor, ReplacementLocator locator) {
        super(visitor);
        this.locator = locator;
        this.translator = locator.getTranslator();
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        if ((access & 0x600) == 1024) {
            this.addMirandaMethods(name, superName, interfaces);
        }
    }

    private void addMirandaMethods(String name, String superName, String[] interfaces) {
        if (interfaces == null) {
            return;
        }
        LinkedHashSet<InheritedMethod> methods = new LinkedHashSet<InheritedMethod>();
        for (String anInterface : interfaces) {
            methods.addAll(this.getMethods(anInterface, true));
        }
        methods.removeAll(this.getMethods(superName, true));
        methods.removeAll(this.getMethods(name, false));
        for (InheritedMethod method : methods) {
            MethodVisitor visitor = this.cv.visitMethod(5121, method.name, method.desc, null, method.exceptions);
            visitor.visitEnd();
        }
    }

    private Set<InheritedMethod> getMethods(String className, boolean recursive) {
        String uniqueTypeName = this.locator.getUniqueTypeName(className);
        LinkedHashSet<InheritedMethod> methods = new LinkedHashSet<InheritedMethod>();
        ClassReader classReader = this.locator.getEnvironment().findClassReader(uniqueTypeName);
        if (classReader == null) {
            return methods;
        }
        MethodCollector collector = new MethodCollector(methods);
        classReader.accept(collector, true);
        if (recursive) {
            if (collector.superName != null) {
                methods.addAll(this.getMethods(collector.superName, true));
            }
            if (collector.interfaces != null) {
                for (String anInterface : collector.interfaces) {
                    methods.addAll(this.getMethods(anInterface, true));
                }
            }
        }
        return methods;
    }

    private static class InheritedMethod {
        public final String name;
        public final String desc;
        public final String[] exceptions;

        public InheritedMethod(String name, String desc, String[] exceptions) {
            this.name = name;
            this.desc = desc;
            this.exceptions = exceptions;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof InheritedMethod) {
                InheritedMethod method = (InheritedMethod)obj;
                return this.name.equals(method.name) && this.desc.equals(method.desc);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodCollector
    extends EmptyVisitor {
        public String superName;
        public String[] interfaces;
        private Set<InheritedMethod> methods;

        public MethodCollector(Set<InheritedMethod> methods) {
            this.methods = methods;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.superName = superName;
            this.interfaces = interfaces;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ((access & 2) == 0 && (access & 8) == 0) {
                this.methods.add(new InheritedMethod(MirandaMethodsVisitor.this.translator.identifier(name), MirandaMethodsVisitor.this.translator.methodDescriptor(desc), MirandaMethodsVisitor.this.translator.typeNames(exceptions)));
            }
            return null;
        }
    }
}

