/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import net.sf.retrotranslator.runtime.asm.FieldVisitor;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.impl.EmptyVisitor;
import net.sf.retrotranslator.transformer.TargetEnvironment;

class MemberFinder
extends EmptyVisitor {
    private final TargetEnvironment environment;
    private final boolean method;
    private final boolean stat;
    private final String name;
    private final String desc;
    private String superName;
    private String[] interfaces;
    private int found;

    public MemberFinder(TargetEnvironment environment, boolean method, boolean stat, String name, String desc) {
        this.environment = environment;
        this.method = method;
        this.stat = stat;
        this.name = name;
        this.desc = desc;
    }

    public int findIn(String className, String location) throws ClassNotFoundException {
        if (className == null) {
            return 0;
        }
        try {
            this.environment.getClassReader(className).accept(this, true);
        }
        catch (ClassNotFoundException e) {
            if (location == null) {
                throw e;
            }
            throw new ClassNotFoundException(e.getMessage() + ", location: " + location, e);
        }
        if (this.found > 0 || this.name.equals("<init>")) {
            return this.found;
        }
        String superClassName = this.superName;
        String[] arr$ = this.interfaces;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String interfaceName = arr$[i$];
            if (this.findIn(interfaceName, className) <= 0) continue;
            return this.found;
        }
        return this.findIn(superClassName, className);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.superName = superName;
        this.interfaces = interfaces;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (!this.method) {
            this.check(access, name, desc);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.method) {
            this.check(access, name, desc);
        }
        return null;
    }

    private void check(int access, String name, String desc) {
        if (name.equals(this.name) && desc.equals(this.desc) && this.stat == ((access & 8) != 0)) {
            ++this.found;
        }
    }
}

