/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JarClassLoader
extends URLClassLoader {
    private File file;

    public JarClassLoader(File file, ClassLoader parent) throws IOException {
        super(JarClassLoader.getClassPath(file), parent);
        this.file = file;
    }

    public String getMainClass() throws IOException {
        return JarClassLoader.getAttribute(this.file, Attributes.Name.MAIN_CLASS);
    }

    private static URL[] getClassPath(File file) throws IOException {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        JarClassLoader.addToPath(urls, file);
        return urls.toArray(new URL[urls.size()]);
    }

    private static void addToPath(Set<URL> classPath, File file) throws IOException {
        if (!(file = file.getCanonicalFile()).exists()) {
            return;
        }
        URL url = file.toURI().toURL();
        if (classPath.contains(url)) {
            return;
        }
        classPath.add(url);
        String attribute = JarClassLoader.getAttribute(file, Attributes.Name.CLASS_PATH);
        if (attribute != null) {
            StringTokenizer tokenizer = new StringTokenizer(attribute);
            while (tokenizer.hasMoreTokens()) {
                JarClassLoader.addToPath(classPath, new File(file.getParent(), tokenizer.nextToken()));
            }
        }
    }

    private static String getAttribute(File file, Attributes.Name name) {
        Attributes attributes = JarClassLoader.getAttributes(file);
        return attributes == null ? null : attributes.getValue(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes getAttributes(File file) {
        Attributes attributes;
        if (!file.isFile()) {
            return null;
        }
        JarFile jarFile = new JarFile(file);
        try {
            Manifest manifest = jarFile.getManifest();
            attributes = manifest == null ? null : manifest.getMainAttributes();
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        jarFile.close();
        return attributes;
    }
}

