/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.io.File;
import net.sf.retrotranslator.runtime.impl.ClassDescriptor;
import net.sf.retrotranslator.runtime.impl.RuntimeTools;
import net.sf.retrotranslator.transformer.ClassTransformer;
import net.sf.retrotranslator.transformer.ClassVersion;
import net.sf.retrotranslator.transformer.JRockitJITRetrotranslator;
import net.sf.retrotranslator.transformer.JarClassLoader;
import net.sf.retrotranslator.transformer.Message;
import net.sf.retrotranslator.transformer.MessageLogger;
import net.sf.retrotranslator.transformer.OperationMode;
import net.sf.retrotranslator.transformer.ReflectionMode;
import net.sf.retrotranslator.transformer.ReplacementLocatorFactory;
import net.sf.retrotranslator.transformer.SunJITRetrotranslator;
import net.sf.retrotranslator.transformer.SystemLogger;
import net.sf.retrotranslator.transformer.TargetEnvironment;
import net.sf.retrotranslator.transformer.TransformerTools;
import net.sf.retrotranslator.transformer.TransformingJarClassLoader;

public class JITRetrotranslator {
    private boolean advanced;
    private boolean smart;
    private String support;
    private String backport;
    private boolean syncvolatile;
    private boolean syncfinal;
    private boolean keepclasslit;
    private ClassTransformer transformer;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$net$sf$retrotranslator$transformer$JITRetrotranslator;

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    public void setSmart(boolean smart) {
        this.smart = smart;
    }

    public void setSupport(String support) {
        this.support = support;
    }

    public void setBackport(String backport) {
        this.backport = backport;
    }

    public void setSyncvolatile(boolean syncvolatile) {
        this.syncvolatile = syncvolatile;
    }

    public void setSyncfinal(boolean syncfinal) {
        this.syncfinal = syncfinal;
    }

    public void setKeepclasslit(boolean keepclasslit) {
        this.keepclasslit = keepclasslit;
    }

    public boolean run() {
        if (JITRetrotranslator.isJava6Supported()) {
            return true;
        }
        OperationMode mode = new OperationMode(this.advanced, this.support, this.smart, ClassVersion.VERSION_14);
        TargetEnvironment environment = new TargetEnvironment(TransformerTools.getDefaultClassLoader(), null, true);
        ReplacementLocatorFactory factory = new ReplacementLocatorFactory(mode, false, this.backport, environment);
        SystemLogger logger = new SystemLogger(new MessageLogger(){

            public void log(Message message) {
            }
        }, false);
        this.transformer = new ClassTransformer(true, false, false, false, this.syncvolatile, this.syncfinal, this.keepclasslit, ReflectionMode.NORMAL, logger, null, factory);
        ClassDescriptor.setBytecodeTransformer(this.transformer);
        SunJITRetrotranslator.install(this.transformer);
        if (JITRetrotranslator.isJava6Supported()) {
            return true;
        }
        JRockitJITRetrotranslator.install(this.transformer);
        return JITRetrotranslator.isJava6Supported();
    }

    private static boolean isJava6Supported() {
        Class<?> clazz = class$net$sf$retrotranslator$transformer$JITRetrotranslator;
        if (clazz == null) {
            clazz = class$net$sf$retrotranslator$transformer$JITRetrotranslator = new JITRetrotranslator[0].getClass().getComponentType();
        }
        byte[] bytes = RuntimeTools.getBytecode(clazz);
        System.arraycopy(new byte[]{0, 0, 0, 50}, 0, bytes, 4, 4);
        try {
            class ClassFactory
            extends ClassLoader {
                ClassFactory() {
                }

                public Class defineClass(String name, byte[] bytes) {
                    return this.defineClass(name, bytes, 0, bytes.length);
                }
            }
            ClassFactory classFactory = new ClassFactory();
            Class<?> clazz2 = class$net$sf$retrotranslator$transformer$JITRetrotranslator;
            if (clazz2 == null) {
                clazz2 = class$net$sf$retrotranslator$transformer$JITRetrotranslator = new JITRetrotranslator[0].getClass().getComponentType();
            }
            classFactory.defineClass(clazz2.getName(), bytes);
            return true;
        }
        catch (ClassFormatError e) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        int i;
        JITRetrotranslator jit = new JITRetrotranslator();
        boolean jar = false;
        for (i = 0; i < args.length; ++i) {
            String option = args[i];
            if (option.equals("-advanced")) {
                jit.setAdvanced(true);
                continue;
            }
            if (option.equals("-smart")) {
                jit.setSmart(true);
                continue;
            }
            if (option.equals("-syncvolatile")) {
                jit.setSyncvolatile(true);
                continue;
            }
            if (option.equals("-syncfinal")) {
                jit.setSyncfinal(true);
                continue;
            }
            if (option.equals("-keepclasslit")) {
                jit.setKeepclasslit(true);
                continue;
            }
            if (option.equals("-support") && i + 1 < args.length) {
                jit.setSupport(args[++i]);
                continue;
            }
            if (option.equals("-backport") && i + 1 < args.length) {
                jit.setBackport(args[++i]);
                continue;
            }
            if (!option.equals("-jar")) break;
            jar = true;
            ++i;
            break;
        }
        if (i == args.length) {
            JITRetrotranslator.printUsageAndExit();
        }
        boolean installed = jit.run();
        if (jar) {
            JarClassLoader classLoader;
            String mainClass;
            File file = new File(args[i]);
            if (!file.isFile()) {
                JITRetrotranslator.printErrorAndExit("Unable to access jarfile " + file);
            }
            if ((mainClass = (classLoader = installed ? new JarClassLoader(file, TransformerTools.getDefaultClassLoader()) : new TransformingJarClassLoader(file, TransformerTools.getDefaultClassLoader(), jit.transformer)).getMainClass()) == null) {
                JITRetrotranslator.printErrorAndExit("Failed to load Main-Class manifest attribute from " + file);
            }
            Thread.currentThread().setContextClassLoader(classLoader);
            JITRetrotranslator.execute(classLoader, mainClass, JITRetrotranslator.remove(args, i + 1));
        } else {
            if (!installed) {
                System.out.println("Cannot install Retrotranslator, use -jar.");
            }
            JITRetrotranslator.execute(TransformerTools.getDefaultClassLoader(), args[i], JITRetrotranslator.remove(args, i + 1));
        }
    }

    private static String[] remove(String[] original, int count) {
        String[] result = new String[original.length - count];
        System.arraycopy(original, original.length - result.length, result, 0, result.length);
        return result;
    }

    private static void execute(ClassLoader classLoader, String mainClass, String[] args) throws Exception {
        try {
            Class<?> clazz = classLoader.loadClass(mainClass);
            Class[] classArray = new Class[1];
            Class<?> clazz2 = array$Ljava$lang$String;
            if (clazz2 == null) {
                clazz2 = array$Ljava$lang$String = new String[0].getClass();
            }
            classArray[0] = clazz2;
            clazz.getMethod("main", classArray).invoke(null, new Object[]{args});
        }
        catch (NoSuchMethodException e) {
            JITRetrotranslator.printErrorAndExit("Could not find the method \"main\" in: " + mainClass);
        }
        catch (ClassNotFoundException e) {
            JITRetrotranslator.printErrorAndExit("Could not find the main class: " + mainClass);
        }
    }

    private static void printUsageAndExit() {
        String version;
        Class<?> clazz = class$net$sf$retrotranslator$transformer$JITRetrotranslator;
        if (clazz == null) {
            clazz = class$net$sf$retrotranslator$transformer$JITRetrotranslator = new JITRetrotranslator[0].getClass().getComponentType();
        }
        String suffix = (version = clazz.getPackage().getImplementationVersion()) == null ? "" : "-" + version;
        StringBuffer builder = new StringBuffer("Usage: java -cp retrotranslator-transformer").append(suffix);
        builder.append(".jar").append(File.pathSeparator);
        builder.append("<classpath> net.sf.retrotranslator.transformer.JITRetrotranslator [-advanced] [-support <features>] [-backport <packages>] [-smart] [-syncvolatile] [-syncfinal] [-keepclasslit] <class> [<args...>]\n");
        builder.append("   or  java -cp retrotranslator-transformer").append(suffix);
        builder.append(".jar net.sf.retrotranslator.transformer.JITRetrotranslator [-advanced] [-support <features>] [-backport <packages>] [-smart] [-syncvolatile] [-syncfinal] [-keepclasslit] -jar <jarfile> [<args...>]");
        System.out.println(builder);
        System.exit(1);
    }

    private static void printErrorAndExit(String msg) {
        System.out.println(msg);
        System.exit(1);
    }
}

