/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.transformer.ClassReplacement;
import net.sf.retrotranslator.transformer.ConstructorReplacement;
import net.sf.retrotranslator.transformer.GenericClassVisitor;
import net.sf.retrotranslator.transformer.MemberKey;
import net.sf.retrotranslator.transformer.MemberReplacement;
import net.sf.retrotranslator.transformer.NameTranslator;
import net.sf.retrotranslator.transformer.ReplacementLocator;
import net.sf.retrotranslator.transformer.TransformerTools;

class GeneralReplacementVisitor
extends GenericClassVisitor {
    private static final String LONG_ARG_DESCRIPTOR = TransformerTools.descriptor(Long.TYPE, new Class[0]);
    private static final String DOUBLE_ARG_DESCRIPTOR = TransformerTools.descriptor(Double.TYPE, new Class[0]);
    private final ReplacementLocator locator;
    private final boolean keepclasslit;
    private final NameTranslator translator;
    private String currentClassName;
    private boolean threadLocalExcluded;

    public GeneralReplacementVisitor(ClassVisitor classVisitor, final ReplacementLocator locator, boolean keepclasslit) {
        super(classVisitor);
        this.locator = locator;
        this.keepclasslit = keepclasslit;
        this.translator = new NameTranslator(){

            protected String typeName(String s) {
                if (GeneralReplacementVisitor.this.isExcluded(s)) {
                    return s;
                }
                return locator.getUniqueTypeName(s);
            }
        };
    }

    protected String identifier(String s) {
        return GeneralReplacementVisitor.fixIdentifier(s);
    }

    protected String typeName(String s) {
        if (this.isExcluded(s)) {
            return s;
        }
        return this.locator.getReferenceTypeName(s);
    }

    protected Object classLiteralTypeOrValue(Object object) {
        return this.keepclasslit ? this.translator.classLiteralTypeOrValue(object) : super.classLiteralTypeOrValue(object);
    }

    protected String classLiteralNameOrDescriptor(String s) {
        return this.keepclasslit ? this.translator.classLiteralNameOrDescriptor(s) : super.classLiteralNameOrDescriptor(s);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.currentClassName = name;
        this.threadLocalExcluded = name.endsWith("ThreadLocal_$Container");
        super.visit(version, access, this.translator.typeName(name), this.translator.declarationSignature(signature), this.translator.typeName(superName), this.translator.typeNames(interfaces));
    }

    private boolean isExcluded(String name) {
        return name == null || this.threadLocalExcluded && (name.equals("java/lang/ThreadLocal") || name.equals("java/lang/InheritableThreadLocal"));
    }

    protected void visitTypeInstruction(MethodVisitor visitor, int opcode, String desc) {
        ClassReplacement classReplacement;
        if (opcode == 187) {
            visitor.visitTypeInsn(opcode, this.translator.typeNameOrDescriptor(desc));
            return;
        }
        if ((opcode == 192 || opcode == 193) && (classReplacement = this.locator.getReplacement(desc)) != null) {
            MemberReplacement method;
            MemberReplacement memberReplacement = method = opcode == 192 ? classReplacement.getCheckCastReplacement() : classReplacement.getInstanceOfReplacement();
            if (method != null && !method.getOwner().equals(this.currentClassName)) {
                visitor.visitMethodInsn(184, method.getOwner(), method.getName(), method.getDesc());
                return;
            }
        }
        super.visitTypeInstruction(visitor, opcode, desc);
    }

    protected void visitFieldInstruction(MethodVisitor visitor, int opcode, String owner, String name, String desc) {
        ClassReplacement replacement;
        if ((opcode == 178 || opcode == 179) && (replacement = this.locator.getReplacement(owner)) != null) {
            MemberKey key = new MemberKey(true, name, this.typeDescriptor(desc));
            MemberReplacement field = replacement.getFieldReplacements().get(key);
            if (field != null && !field.getOwner().equals(this.currentClassName)) {
                visitor.visitFieldInsn(opcode, field.getOwner(), field.getName(), field.getDesc());
                return;
            }
        }
        super.visitFieldInstruction(visitor, opcode, owner, name, desc);
    }

    protected void visitMethodInstruction(MethodVisitor visitor, int opcode, String owner, String name, String desc) {
        ClassReplacement replacement = this.locator.getReplacement(owner);
        if (replacement != null) {
            desc = this.methodDescriptor(desc);
            if (opcode == 183 && name.equals("<init>")) {
                if (this.visitConstructor(replacement, visitor, owner = this.translator.typeName(owner), desc)) {
                    return;
                }
                replacement = this.locator.getReplacement(owner);
                if (replacement != null && this.visitConstructor(replacement, visitor, owner, desc)) {
                    return;
                }
            } else {
                owner = this.typeName(owner);
                MemberKey key = new MemberKey(opcode == 184, name, desc);
                MemberReplacement method = replacement.getMethodReplacements().get(key);
                if (method == null) {
                    replacement = this.locator.getReplacement(owner);
                    MemberReplacement memberReplacement = method = replacement == null ? null : replacement.getMethodReplacements().get(key);
                }
                if (method != null && !method.getOwner().equals(this.currentClassName)) {
                    visitor.visitMethodInsn(184, method.getOwner(), method.getName(), method.getDesc());
                    return;
                }
            }
        }
        super.visitMethodInstruction(visitor, opcode, owner, name, desc);
    }

    private boolean visitConstructor(ClassReplacement replacement, MethodVisitor visitor, String owner, String desc) {
        ConstructorReplacement constructorReplacement = replacement.getConstructorReplacements().get(desc);
        if (constructorReplacement != null) {
            this.buildInstance(visitor, owner, constructorReplacement);
            return true;
        }
        MemberReplacement converter = replacement.getConverterReplacements().get(desc);
        if (converter != null) {
            visitor.visitMethodInsn(184, converter.getOwner(), converter.getName(), converter.getDesc());
            visitor.visitMethodInsn(183, owner, "<init>", ClassReplacement.getConstructorDesc(converter));
            return true;
        }
        return false;
    }

    private void buildInstance(MethodVisitor visitor, String owner, ConstructorReplacement replacement) {
        MemberReplacement[] arguments;
        MemberReplacement creator = replacement.getCreator();
        visitor.visitMethodInsn(184, creator.getOwner(), creator.getName(), creator.getDesc());
        MemberReplacement initializer = replacement.getInitializer();
        if (initializer != null) {
            visitor.visitInsn(92);
        }
        if ((arguments = replacement.getArguments()).length == 0) {
            visitor.visitInsn(87);
        } else {
            this.pushArguments(visitor, arguments);
        }
        visitor.visitMethodInsn(183, owner, "<init>", replacement.getConstructorDesc());
        if (initializer != null) {
            visitor.visitInsn(95);
            visitor.visitMethodInsn(182, initializer.getOwner(), initializer.getName(), initializer.getDesc());
        }
    }

    private void pushArguments(MethodVisitor visitor, MemberReplacement[] arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            boolean notLast;
            MemberReplacement argument = arguments[i];
            boolean bl = notLast = i + 1 < arguments.length;
            if (notLast) {
                visitor.visitInsn(89);
            }
            visitor.visitMethodInsn(182, argument.getOwner(), argument.getName(), argument.getDesc());
            if (!notLast) continue;
            this.swap(visitor, argument);
        }
    }

    private void swap(MethodVisitor visitor, MemberReplacement argument) {
        if (argument.getDesc().equals(LONG_ARG_DESCRIPTOR) || argument.getDesc().equals(DOUBLE_ARG_DESCRIPTOR)) {
            visitor.visitInsn(93);
            visitor.visitInsn(88);
        } else {
            visitor.visitInsn(95);
        }
    }
}

