/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.retrotranslator.transformer.ClassTransformer;
import net.sf.retrotranslator.transformer.ClassVersion;
import net.sf.retrotranslator.transformer.FileContainer;
import net.sf.retrotranslator.transformer.Level;
import net.sf.retrotranslator.transformer.Message;
import net.sf.retrotranslator.transformer.SystemLogger;
import net.sf.retrotranslator.transformer.TargetEnvironment;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EmbeddingConverter {
    private final String embeddingPrefix;
    private final SystemLogger logger;
    private final List<String> prefixes = new ArrayList<String>();
    private final Map<String, Boolean> classNames = new HashMap<String, Boolean>();
    private final TargetEnvironment environment;
    private int countEmbedded;

    public EmbeddingConverter(ClassVersion target, String embed, TargetEnvironment environment, SystemLogger logger) {
        this.environment = environment;
        this.embeddingPrefix = EmbeddingConverter.makePrefix(embed);
        this.logger = logger;
        for (String packageName : environment.readRegistry("embed", target)) {
            this.prefixes.add(EmbeddingConverter.makePrefix(packageName));
        }
    }

    private static String makePrefix(String packageName) {
        return packageName.length() == 0 || packageName.equals(".") ? "" : new StringBuffer().append(packageName.replace('.', '/')).append('/').toString();
    }

    public String convertFileName(String fileName) {
        return this.isEmbedded(fileName) ? new StringBuffer().append(this.embeddingPrefix).append(fileName).toString() : fileName;
    }

    public String convertClassName(String className) {
        if (this.isEmbedded(className)) {
            if (!this.classNames.containsKey(className)) {
                this.classNames.put(className, Boolean.FALSE);
            }
            return new StringBuffer().append(this.embeddingPrefix).append(className).toString();
        }
        return className;
    }

    private boolean isEmbedded(String name) {
        for (String prefix : this.prefixes) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public void embed(FileContainer destination, ClassTransformer transformer) {
        boolean modified;
        if (this.classNames.isEmpty()) {
            this.logger.log(new Message(Level.INFO, "Embedding skipped."));
            return;
        }
        this.logger.log(new Message(Level.INFO, "Embedding backported classes."));
        this.countEmbedded = 0;
        do {
            modified = false;
            for (Map.Entry<String, Boolean> entry : new HashMap<String, Boolean>(this.classNames).entrySet()) {
                modified |= this.embed(entry, destination, transformer);
            }
        } while (modified);
        this.logger.log(new Message(Level.INFO, new StringBuffer().append("Embedded ").append(this.countEmbedded).append(" class(es).").toString()));
        this.classNames.clear();
    }

    private boolean embed(Map.Entry<String, Boolean> entry, FileContainer destination, ClassTransformer transformer) {
        if (entry.getValue().booleanValue()) {
            return false;
        }
        String name = entry.getKey();
        String fileName = new StringBuffer().append(name).append(".class").toString();
        this.logger.log(new Message(Level.VERBOSE, "Embedding", null, fileName));
        this.classNames.put(name, Boolean.TRUE);
        byte[] content = this.environment.getClassContent(name);
        if (content != null) {
            destination.putEntry(this.convertFileName(fileName), transformer.transform(content, 0, content.length), true);
            ++this.countEmbedded;
            return true;
        }
        this.logger.log(new Message(Level.WARNING, new StringBuffer().append("Cannot find to embed: ").append(name).toString()));
        return false;
    }
}

