/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.transformer;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.sf.retrotranslator.runtime.asm.ClassAdapter;
import net.sf.retrotranslator.runtime.asm.ClassVisitor;
import net.sf.retrotranslator.runtime.asm.MethodVisitor;
import net.sf.retrotranslator.runtime.asm.signature.SignatureReader;
import net.sf.retrotranslator.runtime.asm.signature.SignatureVisitor;
import net.sf.retrotranslator.runtime.asm.signature.SignatureWriter;
import net.sf.retrotranslator.runtime.impl.RuntimeTools;
import net.sf.retrotranslator.transformer.Level;
import net.sf.retrotranslator.transformer.MethodCounter;
import net.sf.retrotranslator.transformer.SignatureAdapter;
import net.sf.retrotranslator.transformer.SystemLogger;

class DuplicateInterfacesVisitor
extends ClassAdapter {
    private final SystemLogger logger;
    private final MethodCounter counter;

    public DuplicateInterfacesVisitor(ClassVisitor cv, SystemLogger logger, MethodCounter counter) {
        super(cv);
        this.logger = logger;
        this.counter = counter;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String[] cleanInterfaces = this.cleanInterfaces(interfaces);
        String cleanSignature = cleanInterfaces == interfaces ? signature : this.cleanSignature(signature);
        super.visit(version, access, name, cleanSignature, superName, cleanInterfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.counter.increment(name, desc);
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    private String[] cleanInterfaces(String[] values) {
        if (values == null) {
            return null;
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        String[] arr$ = values;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String s = arr$[i$];
            if (set.add(s)) continue;
            this.logger.logForFile(Level.VERBOSE, "Repetitive interface name removed: " + RuntimeTools.getDisplayClassName(s));
        }
        if (set.size() == values.length) {
            return values;
        }
        return set.toArray(new String[set.size()]);
    }

    private String cleanSignature(String signature) {
        if (signature == null) {
            return null;
        }
        SignatureWriter writer = new SignatureWriter();
        new SignatureReader(signature).accept(new SignatureCleaningVisitor(writer));
        return writer.toString();
    }

    private static class SignatureCleaningVisitor
    extends SignatureAdapter {
        private Set<String> interfaces = new HashSet<String>();

        public SignatureCleaningVisitor(SignatureVisitor visitor) {
            super(visitor);
        }

        private void addInterface(String signature) {
            new SignatureReader(signature).acceptType(super.visitInterface());
        }

        public SignatureVisitor visitInterface() {
            final SignatureWriter writer = new SignatureWriter();
            return new SignatureAdapter(writer){
                private String interfaceName;

                public void visitClassType(String name) {
                    super.visitClassType(name);
                    this.interfaceName = name;
                }

                public void visitEnd() {
                    super.visitEnd();
                    if (SignatureCleaningVisitor.this.interfaces.add(this.interfaceName)) {
                        SignatureCleaningVisitor.this.addInterface(writer.toString());
                    }
                }
            };
        }
    }
}

