/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.segment.detectJunctions;

import java.util.ArrayList;
import java.util.List;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.roi.geom.real.WritablePolyline;
import net.imglib2.roi.util.RealLocalizableRealPositionable;
import net.imglib2.util.Intervals;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Segment.DetectJunctions.class)
public class DefaultDetectJunctions
extends AbstractUnaryFunctionOp<List<? extends WritablePolyline>, List<RealPoint>>
implements Ops.Segment.DetectJunctions,
Contingent {
    @Parameter(required=false)
    private double threshold = 2.0;

    private boolean areClose(RealPoint p1, RealPoint p2) {
        return this.getDistance((RealLocalizable)p1, (RealLocalizable)p2) <= this.threshold;
    }

    private boolean areClose(RealPoint p1, List<RealPoint> points) {
        for (RealPoint p : points) {
            if (!this.areClose(p1, p)) continue;
            return true;
        }
        return false;
    }

    private static Interval slightlyEnlarge(RealInterval realInterval, long border) {
        return Intervals.expand((Interval)Intervals.smallestContainingInterval((RealInterval)realInterval), (long)border);
    }

    private double getDistance(double[] point1, RealLocalizable point2) {
        return Math.sqrt(Math.pow(point2.getDoublePosition(0) - point1[0], 2.0) + Math.pow(point2.getDoublePosition(1) - point1[1], 2.0));
    }

    private double getDistance(RealLocalizable point1, RealLocalizable point2) {
        return Math.sqrt(Math.pow(point2.getDoublePosition(0) - point1.getDoublePosition(0), 2.0) + Math.pow(point2.getDoublePosition(1) - point1.getDoublePosition(1), 2.0));
    }

    private RealPoint makeRealPoint(RealLocalizableRealPositionable input) {
        return new RealPoint((RealLocalizable)input);
    }

    @Override
    public List<RealPoint> calculate(List<? extends WritablePolyline> input) {
        ArrayList<RealPoint> output = new ArrayList<RealPoint>();
        for (int first = 0; first < input.size() - 1; ++first) {
            WritablePolyline firstLine = input.get(first);
            for (int second = first + 1; second < input.size(); ++second) {
                WritablePolyline secondLine = input.get(second);
                FinalInterval intersect = Intervals.intersect((Interval)DefaultDetectJunctions.slightlyEnlarge((RealInterval)firstLine, 2L), (Interval)DefaultDetectJunctions.slightlyEnlarge((RealInterval)secondLine, 2L));
                if (Intervals.isEmpty((Interval)intersect)) continue;
                ArrayList<RealPoint> currentPairJunctions = new ArrayList<RealPoint>();
                for (int p = 0; p < firstLine.numVertices() - 1; ++p) {
                    for (int q = 0; q < secondLine.numVertices() - 1; ++q) {
                        double mp;
                        double y;
                        double x;
                        RealLocalizableRealPositionable p1 = firstLine.vertex(p);
                        RealLocalizableRealPositionable p2 = firstLine.vertex(p + 1);
                        RealLocalizableRealPositionable q1 = secondLine.vertex(q);
                        RealLocalizableRealPositionable q2 = secondLine.vertex(q + 1);
                        boolean pVertical = Math.round(p1.getDoublePosition(0)) == Math.round(p2.getDoublePosition(0));
                        boolean qVertical = Math.round(q1.getDoublePosition(0)) == Math.round(q2.getDoublePosition(0));
                        double[] intersectionPoint = new double[2];
                        if (pVertical && qVertical) {
                            this.parallelRoutine(p1, p2, q1, q2, currentPairJunctions, true);
                            continue;
                        }
                        if (pVertical) {
                            double mq = (q2.getDoublePosition(1) - q1.getDoublePosition(1)) / (q2.getDoublePosition(0) - q1.getDoublePosition(0));
                            double bq = q1.getDoublePosition(1) - mq * q1.getDoublePosition(0);
                            x = p1.getDoublePosition(0);
                            y = mq * x + bq;
                            intersectionPoint[0] = x;
                            intersectionPoint[1] = y;
                        } else if (qVertical) {
                            mp = (p2.getDoublePosition(1) - p1.getDoublePosition(1)) / (p2.getDoublePosition(0) - p1.getDoublePosition(0));
                            double bp = p1.getDoublePosition(1) - mp * p1.getDoublePosition(0);
                            x = q1.getDoublePosition(0);
                            y = mp * x + bp;
                            intersectionPoint[0] = x;
                            intersectionPoint[1] = y;
                        } else {
                            double mq;
                            mp = (p2.getDoublePosition(1) - p1.getDoublePosition(1)) / (p2.getDoublePosition(0) - p1.getDoublePosition(0));
                            if (mp == (mq = (q2.getDoublePosition(1) - q1.getDoublePosition(1)) / (q2.getDoublePosition(0) - q1.getDoublePosition(0)))) {
                                this.parallelRoutine(p1, p2, q1, q2, currentPairJunctions, false);
                                continue;
                            }
                            double bp = p2.getDoublePosition(1) - mp * p2.getDoublePosition(0);
                            double bq = q2.getDoublePosition(1) - mq * q2.getDoublePosition(0);
                            double x2 = (bq - bp) / (mp - mq);
                            double y2 = mp * x2 + bp;
                            intersectionPoint[0] = x2;
                            intersectionPoint[1] = y2;
                        }
                        double distp1 = this.getDistance(intersectionPoint, (RealLocalizable)p1);
                        double distp2 = this.getDistance(intersectionPoint, (RealLocalizable)p2);
                        double distq1 = this.getDistance(intersectionPoint, (RealLocalizable)q1);
                        double distq2 = this.getDistance(intersectionPoint, (RealLocalizable)q2);
                        double maxDist = Math.max(Math.min(distp1, distp2), Math.min(distq1, distq2));
                        if (!(maxDist <= this.threshold)) continue;
                        currentPairJunctions.add(new RealPoint(intersectionPoint));
                    }
                }
                this.filterJunctions(currentPairJunctions);
                for (RealPoint point : currentPairJunctions) {
                    output.add(point);
                }
            }
        }
        this.filterJunctions(output);
        return output;
    }

    private void filterJunctions(List<RealPoint> list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            ArrayList<RealPoint> similars = new ArrayList<RealPoint>();
            similars.add(list.get(i));
            list.remove(i);
            for (int j = 0; j < list.size(); ++j) {
                if (!this.areClose(list.get(j), similars)) continue;
                similars.add(list.get(j));
                list.remove(j);
                --j;
            }
            if (list.size() > 0) {
                list.add(i, this.averagePoints(similars));
                continue;
            }
            list.add(this.averagePoints(similars));
        }
    }

    private RealPoint averagePoints(ArrayList<RealPoint> list) {
        double[] pos = new double[]{0.0, 0.0};
        for (RealPoint p : list) {
            pos[0] = pos[0] + p.getDoublePosition(0);
            pos[1] = pos[1] + p.getDoublePosition(1);
        }
        pos[0] = pos[0] / (double)list.size();
        pos[1] = pos[1] / (double)list.size();
        return new RealPoint(pos);
    }

    private <L extends RealLocalizable & RealPositionable> void parallelRoutine(RealLocalizableRealPositionable p1, RealLocalizableRealPositionable p2, RealLocalizableRealPositionable q1, RealLocalizableRealPositionable q2, List<RealPoint> junctions, boolean areVertical) {
        boolean sameLine = false;
        if (areVertical && Math.round(p1.getDoublePosition(0)) == Math.round(q1.getDoublePosition(0))) {
            sameLine = true;
        } else {
            double bq;
            double m = (q2.getDoublePosition(1) - q1.getDoublePosition(1)) / (q2.getDoublePosition(0) - q1.getDoublePosition(0));
            double bp = p2.getDoublePosition(1) - m * p2.getDoublePosition(0);
            if (bp == (bq = q2.getDoublePosition(1) - m * q2.getDoublePosition(0))) {
                sameLine = true;
            }
        }
        if (!sameLine && Math.min(Math.min(this.getDistance((RealLocalizable)p1, (RealLocalizable)q1), this.getDistance((RealLocalizable)p2, (RealLocalizable)q1)), Math.min(this.getDistance((RealLocalizable)p1, (RealLocalizable)q2), this.getDistance((RealLocalizable)p2, (RealLocalizable)q2))) > this.threshold) {
            return;
        }
        int foundJunctions = 0;
        double lengthp = this.getDistance((RealLocalizable)p1, (RealLocalizable)p2);
        double lengthq = this.getDistance((RealLocalizable)q1, (RealLocalizable)q2);
        if (this.getDistance((RealLocalizable)p1, (RealLocalizable)q1) < lengthq && this.getDistance((RealLocalizable)p1, (RealLocalizable)q2) < lengthq && sameLine || Math.min(this.getDistance((RealLocalizable)p1, (RealLocalizable)q1), this.getDistance((RealLocalizable)p1, (RealLocalizable)q2)) < this.threshold) {
            junctions.add(this.makeRealPoint(p1));
            ++foundJunctions;
        }
        if (this.getDistance((RealLocalizable)p2, (RealLocalizable)q1) < lengthq && this.getDistance((RealLocalizable)p2, (RealLocalizable)q2) < lengthq && sameLine || Math.min(this.getDistance((RealLocalizable)p2, (RealLocalizable)q1), this.getDistance((RealLocalizable)p2, (RealLocalizable)q2)) < this.threshold) {
            junctions.add(this.makeRealPoint(p2));
            ++foundJunctions;
        }
        if ((this.getDistance((RealLocalizable)q1, (RealLocalizable)p1) < lengthp && this.getDistance((RealLocalizable)q1, (RealLocalizable)p2) < lengthp && sameLine || Math.min(this.getDistance((RealLocalizable)q1, (RealLocalizable)p1), this.getDistance((RealLocalizable)q1, (RealLocalizable)p2)) < this.threshold) && foundJunctions < 2) {
            junctions.add(this.makeRealPoint(q1));
            ++foundJunctions;
        }
        if ((this.getDistance((RealLocalizable)q2, (RealLocalizable)p1) < lengthp && this.getDistance((RealLocalizable)q2, (RealLocalizable)p2) < lengthp && sameLine || Math.min(this.getDistance((RealLocalizable)q2, (RealLocalizable)p1), this.getDistance((RealLocalizable)q2, (RealLocalizable)p2)) < this.threshold) && foundJunctions < 2) {
            junctions.add(this.makeRealPoint(q2));
            ++foundJunctions;
        }
    }

    @Override
    public boolean conforms() {
        if (((List)this.in()).size() < 1) {
            return false;
        }
        return ((WritablePolyline)((List)this.in()).get(0)).vertex(0).numDimensions() == 2;
    }
}

