/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.morphology.dilate;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.map.Maps;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractBinaryHybridCF;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.morphology.Dilation;
import net.imglib2.algorithm.morphology.MorphologyUtils;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Morphology.Dilate.class)
public class DefaultDilate<T extends RealType<T>>
extends AbstractBinaryHybridCF<RandomAccessibleInterval<T>, Shape, IterableInterval<T>>
implements Ops.Morphology.Dilate,
Contingent {
    @Parameter(required=false)
    private boolean isFull;
    @Parameter(required=false)
    private OutOfBoundsFactory<T, RandomAccessibleInterval<T>> f;
    private T minVal;
    private UnaryFunctionOp<Dimensions, Img<T>> imgCreator;

    @Override
    public boolean conforms() {
        if (this.in1() == null || this.in2() == null || this.out() == null) {
            return true;
        }
        return this.isFull || Maps.compatible((RandomAccessibleInterval)this.in(), (IterableInterval)this.out());
    }

    @Override
    public void initialize() {
        this.minVal = (RealType)((RealType)Util.getTypeFromInterval((Interval)((Interval)this.in()))).createVariable();
        this.minVal.setReal(this.minVal.getMinValue());
        if (this.f == null) {
            this.f = new OutOfBoundsConstantValueFactory(this.minVal);
        }
        this.imgCreator = Functions.unary(this.ops(), Ops.Create.Img.class, Img.class, this.in(), this.minVal.createVariable());
        if (this.out() == null) {
            this.setOutput(this.createOutput(this.in()));
        }
    }

    @Override
    public IterableInterval<T> createOutput(RandomAccessibleInterval<T> in1, Shape in2) {
        if (this.isFull) {
            long[] dims = MorphologyUtils.computeTargetImageDimensionsAndOffset(in1, (Shape)in2)[0];
            return (IterableInterval)this.imgCreator.calculate((Dimensions)new FinalInterval(dims));
        }
        return (IterableInterval)this.imgCreator.calculate((Dimensions)in1);
    }

    @Override
    public void compute(RandomAccessibleInterval<T> in1, Shape in2, IterableInterval<T> output) {
        IntervalView shifted;
        if (this.isFull) {
            long[] offset = MorphologyUtils.computeTargetImageDimensionsAndOffset(in1, (Shape)in2)[1];
            shifted = Views.translate(in1, (long[])offset);
        } else {
            shifted = in1;
        }
        ExtendedRandomAccessibleInterval extended = Views.extend(shifted, this.f);
        Dilation.dilate((RandomAccessible)extended, output, (Shape)in2, this.minVal, (int)this.ops().getMaxThreads());
    }
}

