/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.distancetransform;

import java.util.concurrent.Callable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;

class Phase2Runnable3DCal<T extends RealType<T>>
implements Callable<Void> {
    private final double[][][] tempValues;
    private final double[][][] tempValues_new;
    private final int xPos;
    private final int zPos;
    private final int height;
    private final double[] calibration;

    public Phase2Runnable3DCal(double[][][] tempValues, double[][][] tempValues_new, RandomAccessibleInterval<T> raOut, int xPos, int zPos, double[] calibration) {
        this.tempValues = tempValues;
        this.tempValues_new = tempValues_new;
        this.xPos = xPos;
        this.zPos = zPos;
        this.height = (int)raOut.dimension(1);
        this.calibration = calibration;
    }

    private double distancefunc(int x, int i, double raOutValue) {
        return this.calibration[1] * this.calibration[1] * (double)(x - i) * (double)(x - i) + raOutValue * raOutValue;
    }

    private int sep(int i, int u, double w, double v) {
        return (int)Math.floor(Math.nextUp(((double)(u * u - i * i) + w * w / (this.calibration[1] * this.calibration[1]) - v * v / (this.calibration[1] * this.calibration[1])) / (double)(2 * (u - i))));
    }

    @Override
    public Void call() throws Exception {
        int u;
        int[] s = new int[this.height];
        int[] t = new int[this.height];
        int q = 0;
        s[0] = 0;
        t[0] = 0;
        for (u = 1; u < this.height; ++u) {
            while (q >= 0 && this.distancefunc(t[q], s[q], this.tempValues[this.xPos][s[q]][this.zPos]) > this.distancefunc(t[q], u, this.tempValues[this.xPos][u][this.zPos])) {
                --q;
            }
            if (q < 0) {
                q = 0;
                s[0] = u;
                continue;
            }
            int w = 1 + this.sep(s[q], u, this.tempValues[this.xPos][u][this.zPos], this.tempValues[this.xPos][s[q]][this.zPos]);
            if (w >= this.height) continue;
            s[++q] = u;
            t[q] = w;
        }
        for (u = this.height - 1; u >= 0; --u) {
            this.tempValues_new[this.xPos][u][this.zPos] = this.distancefunc(u, s[q], this.tempValues[this.xPos][s[q]][this.zPos]);
            if (u != t[q]) continue;
            --q;
        }
        return null;
    }
}

