/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.create.img;

import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.ImgView;
import net.imglib2.type.Type;
import net.imglib2.view.Views;

public final class Imgs {
    private Imgs() {
    }

    public static <T extends Type<T>> Img<T> create(ImgFactory<T> factory, Dimensions dims, T type) {
        return Imgs.adjustMinMax(factory.imgFactory(type).create(dims), dims);
    }

    public static <T extends Type<T>> Img<T> adjustMinMax(Img<T> img, Object minMax) {
        if (!(minMax instanceof Interval)) {
            return img;
        }
        Interval interval = (Interval)minMax;
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        for (int d = 0; d < min.length; ++d) {
            if (min[d] == 0L) continue;
            return ImgView.wrap((RandomAccessibleInterval)Views.translate(img, (long[])min), (ImgFactory)img.factory());
        }
        return img;
    }
}

