/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.coloc;

import java.util.Random;
import net.imagej.ops.coloc.ColocUtil;
import net.imglib2.AbstractInterval;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.View;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.view.Views;

public class ShuffledView<T>
extends AbstractInterval
implements RandomAccessibleInterval<T>,
View {
    private Random rng;
    private final RandomAccessibleInterval<T> image;
    private int[] blockIndices;
    private int[] blockSize;
    private int[] blockDims;

    public ShuffledView(RandomAccessibleInterval<T> image, int[] blockSize, long seed) {
        this(image, blockSize, null, seed);
    }

    private ShuffledView(RandomAccessibleInterval<T> image, int[] blockSize, int[] blockIndices, long seed) {
        super(image);
        this.image = image;
        this.blockSize = blockSize;
        int numDims = image.numDimensions();
        this.blockDims = new int[numDims];
        long totalBlocks = 1L;
        for (int d = 0; d < numDims; ++d) {
            long blockDim = image.dimension(d) / (long)blockSize[d];
            if (blockDim * (long)blockSize[d] != image.dimension(d)) {
                throw new IllegalArgumentException("Image dimension #" + d + " is not evenly divisible by block size:" + blockSize[d] + "; Please call a ShuffledView.cropAt method to adjust the input.");
            }
            if (blockDim > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Block dimension #" + d + " is too large: " + blockDim);
            }
            this.blockDims[d] = (int)blockDim;
            totalBlocks *= (long)this.blockDims[d];
        }
        if (totalBlocks > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Too many blocks: " + totalBlocks);
        }
        if (blockIndices == null) {
            this.blockIndices = new int[(int)totalBlocks];
            this.initializeBlocks();
            this.rng = new Random(seed);
            this.shuffleBlocks();
        } else {
            this.blockIndices = blockIndices;
        }
    }

    private void initializeBlocks() {
        for (int b = 0; b < this.blockIndices.length; ++b) {
            this.blockIndices[b] = b;
        }
    }

    public void shuffleBlocks() {
        if (this.rng == null) {
            throw new IllegalStateException("No seed provided. Cannot shuffle.");
        }
        ColocUtil.shuffle(this.blockIndices, this.rng);
    }

    public void shuffleBlocks(long seed) {
        this.rng.setSeed(seed);
        this.initializeBlocks();
        this.shuffleBlocks();
    }

    public RandomAccess<T> randomAccess() {
        return new ShuffledRandomAccess();
    }

    public RandomAccess<T> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public T getType() {
        return (T)this.image.getType();
    }

    public static <T> RandomAccessibleInterval<T> cropAtMin(RandomAccessibleInterval<T> image, int[] blockSize) {
        return ShuffledView.cropAt(image, blockSize, (Localizable)new Point(image.numDimensions()));
    }

    public static <T> RandomAccessibleInterval<T> cropAtMax(RandomAccessibleInterval<T> image, int[] blockSize) {
        long[] pos = new long[image.numDimensions()];
        for (int d = 0; d < pos.length; ++d) {
            pos[d] = image.dimension(d) % (long)blockSize[d];
        }
        return ShuffledView.cropAt(image, blockSize, (Localizable)new Point(pos));
    }

    public static <T> RandomAccessibleInterval<T> cropAtCenter(RandomAccessibleInterval<T> image, int[] blockSize) {
        long[] pos = new long[image.numDimensions()];
        for (int d = 0; d < pos.length; ++d) {
            pos[d] = image.dimension(d) % (long)blockSize[d] / 2L;
        }
        return ShuffledView.cropAt(image, blockSize, (Localizable)new Point(pos));
    }

    private static <T> RandomAccessibleInterval<T> cropAt(RandomAccessibleInterval<T> image, int[] blockSize, Localizable offset) {
        int numDims = image.numDimensions();
        long[] minsize = new long[numDims * 2];
        for (int d = 0; d < numDims; ++d) {
            minsize[d] = offset.getLongPosition(d);
            long shaveSize = image.dimension(d) % (long)blockSize[d];
            minsize[numDims + d] = image.dimension(d) - shaveSize;
        }
        return Views.interval(image, (Interval)FinalInterval.createMinSize((long[])minsize));
    }

    private class ShuffledRandomAccess
    extends Point
    implements RandomAccess<T> {
        private final RandomAccess<T> imageRA;
        private final long[] blockPos;
        private final long[] blockOffset;
        private final long[] shuffledBlockPos;

        public ShuffledRandomAccess() {
            super(ShuffledView.this.image.numDimensions());
            this.imageRA = ShuffledView.this.image.randomAccess();
            this.blockPos = new long[this.position.length];
            this.blockOffset = new long[this.position.length];
            this.shuffledBlockPos = new long[this.position.length];
        }

        public T get() {
            for (int d = 0; d < this.position.length; ++d) {
                this.blockPos[d] = this.position[d] / (long)ShuffledView.this.blockSize[d];
                this.blockOffset[d] = this.position[d] % (long)ShuffledView.this.blockSize[d];
            }
            int blockIndex = IntervalIndexer.positionToIndex((long[])this.blockPos, (int[])ShuffledView.this.blockDims);
            int shuffledBlockIndex = ShuffledView.this.blockIndices[blockIndex];
            IntervalIndexer.indexToPosition((int)shuffledBlockIndex, (int[])ShuffledView.this.blockDims, (long[])this.shuffledBlockPos);
            for (int d = 0; d < this.position.length; ++d) {
                long pd = this.shuffledBlockPos[d] * (long)ShuffledView.this.blockSize[d] + this.blockOffset[d];
                this.imageRA.setPosition(pd, d);
            }
            return this.imageRA.get();
        }

        public RandomAccess<T> copy() {
            throw new UnsupportedOperationException();
        }
    }
}

