/*
 * Decompiled with CFR 0.152.
 */
package levelsets.ij;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import levelsets.filter.Filter;
import levelsets.ij.ImageProgressContainer;

public class ImageContainer {
    protected ImagePlus ip = null;
    protected String title = "Level set workset";
    protected ImageProcessor[] sproc;
    protected final short[][] proc_pixels;
    protected int width = 0;
    protected int stack_size = 0;
    protected boolean isStack = false;
    private int pixel;
    protected ShortProcessor lproc = null;

    public ImageContainer() {
        this.proc_pixels = null;
    }

    public ImageContainer(ImagePlus ip) {
        this.ip = ip;
        this.stack_size = ip.getStackSize();
        this.isStack = this.stack_size > 1;
        this.sproc = new ShortProcessor[this.stack_size];
        this.proc_pixels = new short[this.stack_size][];
        if (this.isStack) {
            for (int i = 0; i < this.stack_size; ++i) {
                this.sproc[i] = (ShortProcessor)ip.getStack().getProcessor(i + 1).convertToShort(false);
                this.proc_pixels[i] = (short[])this.sproc[i].getPixels();
            }
        } else {
            this.sproc[0] = (ShortProcessor)ip.getProcessor().convertToShort(false);
            this.proc_pixels[0] = (short[])this.sproc[0].getPixels();
        }
        this.width = this.sproc[0].getWidth();
    }

    public ImageContainer(ImageProcessor[] iproc) {
        this.stack_size = iproc.length;
        this.isStack = this.stack_size > 1;
        this.sproc = new ShortProcessor[this.stack_size];
        this.proc_pixels = new short[this.stack_size][];
        for (int i = 0; i < this.stack_size; ++i) {
            this.sproc[i] = (ShortProcessor)iproc[i].convertToShort(false);
            this.proc_pixels[i] = (short[])this.sproc[i].getPixels();
        }
        this.width = this.sproc[0].getWidth();
    }

    private ImageContainer(ShortProcessor[] iproc) {
        this.stack_size = iproc.length;
        this.isStack = this.stack_size > 1;
        this.sproc = new ShortProcessor[this.stack_size];
        this.proc_pixels = new short[this.stack_size][];
        for (int i = 0; i < this.stack_size; ++i) {
            this.sproc[i] = (ShortProcessor)iproc[i].duplicate().convertToShort(false);
            this.proc_pixels[i] = (short[])this.sproc[i].getPixels();
        }
        this.width = this.sproc[0].getWidth();
    }

    public final ImagePlus createImagePlus(String title) {
        if (title != null) {
            this.title = title;
        }
        if (this.ip != null) {
            this.ip.setTitle(this.title);
            return this.ip;
        }
        if (this.isStack) {
            ImageStack is = new ImageStack(this.getWidth(), this.getHeight());
            for (int i = 0; i < this.stack_size; ++i) {
                is.addSlice("", this.sproc[i]);
            }
            int slice = null != this.ip ? this.ip.getCurrentSlice() : 1;
            this.ip = new ImagePlus(this.title, is);
            this.ip.setSlice(slice);
        } else {
            this.ip = new ImagePlus(this.title, this.sproc[0]);
        }
        return this.ip;
    }

    public final ImagePlus updateImagePlus(String title) {
        if (title != null) {
            this.title = title;
        }
        if (this.isStack) {
            ImageStack is = new ImageStack(this.getWidth(), this.getHeight());
            for (int i = 0; i < this.stack_size; ++i) {
                is.addSlice("", this.sproc[i]);
            }
            if (this.ip == null) {
                this.ip = new ImagePlus(this.title, is);
            } else {
                this.ip.setStack(this.title, is);
            }
        } else if (this.ip == null) {
            this.ip = new ImagePlus(this.title, this.sproc[0]);
        } else {
            this.ip.setProcessor(this.title, this.sproc[0]);
        }
        return this.ip;
    }

    public final int getImageCount() {
        return this.stack_size;
    }

    public final int getPixel(int x, int y, int z) {
        int pos = y * this.width + x;
        if (pos >= this.proc_pixels[0].length) {
            System.out.println("Exception: x=" + x + ",y=" + y);
            IJ.log((String)("Exception: x=" + x + ",y=" + y));
        }
        if (this.isStack) {
            return this.proc_pixels[z][pos];
        }
        return this.proc_pixels[0][pos];
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.sproc[0].getHeight();
    }

    public final void setPixel(int x, int y, int z, int pixel) {
        if (this.isStack) {
            this.proc_pixels[z][x * this.width + y] = (short)pixel;
        } else {
            this.proc_pixels[0][x * this.width + y] = (short)pixel;
        }
    }

    public final ImageContainer deepCopy() {
        return new ImageContainer(this.sproc);
    }

    public final ImageProgressContainer progressCopy() {
        return new ImageProgressContainer(this);
    }

    public final void setData(double[][][] data) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                for (int k = 0; k < data[0][0].length; ++k) {
                    if (data[i][j][k] == Double.MAX_VALUE) continue;
                    int current = (int)Math.abs(data[i][j][k]);
                    if (current < min) {
                        min = current;
                    }
                    if (current <= max) continue;
                    max = current;
                }
            }
        }
        int add = -1 * min;
        double scaler = 255.0 / (double)(max + add - (min + add));
        for (int z = 0; z < this.getImageCount(); ++z) {
            for (int x = 0; x < this.getWidth(); ++x) {
                for (int y = 0; y < this.getHeight(); ++y) {
                    if (data[x][y][z] == Double.MAX_VALUE) continue;
                    this.setPixel(x, y, z, (int)Math.round((double)((int)Math.abs(data[x][y][z]) + add) * scaler));
                }
            }
        }
    }

    public final double[][][] calculateGradients() {
        double zScale = this.getzScale();
        double[][][] gradients = new double[this.getWidth()][this.getHeight()][this.getImageCount()];
        for (int z = 0; z < gradients[0][0].length; ++z) {
            for (int x = 1; x < gradients.length - 1; ++x) {
                for (int y = 1; y < gradients[0].length - 1; ++y) {
                    double xGradient = (this.getPixel(x + 1, y, z) - this.getPixel(x - 1, y, z)) / 2;
                    double yGradient = (this.getPixel(x, y + 1, z) - this.getPixel(x, y - 1, z)) / 2;
                    double zGradient = z > 0 && z < gradients[0][0].length - 1 ? (double)(this.getPixel(x, y, z + 1) - this.getPixel(x, y, z - 1)) / (2.0 * zScale) : 0.0;
                    gradients[x][y][z] = Math.sqrt(xGradient * xGradient + yGradient * yGradient + zGradient * zGradient);
                }
            }
        }
        return gradients;
    }

    public final void applyFilter(Filter filter) {
        this.applyFilter(filter, 0, this.stack_size - 1);
    }

    public final void applyFilter(Filter filter, int start, int end) {
        IJ.log((String)("Applying filter : " + filter.getClass().getCanonicalName() + " (on images " + start + " to " + end + ")"));
        if (this.sproc == null) {
            return;
        }
        for (int i = start; i <= end; ++i) {
            short[] src_pix = (short[])this.sproc[i].getPixels();
            short[] pix = new short[src_pix.length];
            int width = this.sproc[i].getWidth();
            int height = this.sproc[i].getHeight();
            filter.filter(width, height, src_pix, pix);
            this.sproc[i] = new ShortProcessor(width, height, pix, null);
        }
    }

    public final BufferedImage ij2bufferedImage(Image im) {
        BufferedImage bi = new BufferedImage(im.getWidth(null), im.getHeight(null), 11);
        Graphics bg = bi.getGraphics();
        bg.drawImage(im, 0, 0, null);
        bg.dispose();
        return bi;
    }

    public final double getzScale() {
        return 1.0;
    }
}

