/*
 * Decompiled with CFR 0.152.
 */
package levelsets.filter;

import ij.process.ShortProcessor;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import levelsets.filter.ConvolutionFilter;
import levelsets.filter.Filter;

public class Sobel
implements Filter {
    public static float[] HORIZONTAL_KERNEL = new float[]{1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, -2.0f, -1.0f};
    public static float[] VERTICAL_KERNEL = new float[]{-1.0f, 0.0f, 1.0f, -2.0f, 0.0f, 2.0f, -1.0f, 0.0f, 1.0f};

    @Override
    public BufferedImage filter(BufferedImage input) {
        System.out.println("Sobel filter");
        ConvolutionFilter laplace = new ConvolutionFilter(ConvolutionFilter.LAPLACE_EDGE_KERNEL);
        BufferedImage laplace_image = laplace.filter(input);
        double[][][] data = new double[input.getWidth()][input.getHeight()][1];
        int[] pixel = new int[4];
        WritableRaster laplace_raster = laplace_image.getRaster();
        for (int x = 0; x < input.getWidth(); ++x) {
            for (int y = 0; y < input.getHeight(); ++y) {
                double[] dArray = data[x][y];
                dArray[0] = dArray[0] + (double)laplace_raster.getPixel(x, y, pixel)[0];
                if (!(data[x][y][0] > 255.0)) continue;
                data[x][y][0] = 255.0;
            }
        }
        return null;
    }

    @Override
    public void filter(int width, int height, short[] source, short[] target) {
        ShortProcessor sp = new ShortProcessor(width, height, source, null);
        BufferedImage bi = this.filter(sp.get16BitBufferedImage());
        DataBufferUShort db = (DataBufferUShort)bi.getData().getDataBuffer();
        System.arraycopy(target, 0, db.getData(), 0, target.length);
    }
}

