/*
 * Decompiled with CFR 0.152.
 */
package levelsets.filter;

import ij.process.ShortProcessor;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import levelsets.filter.Filter;

public class ConvolutionFilter
implements Filter {
    public static float[] LAPLACE_EDGE_KERNEL = new float[]{1.0f, 1.0f, 1.0f, 1.0f, -8.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    public static float[] GAUSSIAN_SMOOTH_KERNEL = new float[]{0.012578616f, 0.025157232f, 0.031446543f, 0.025157232f, 0.012578616f, 0.025157232f, 0.056603774f, 0.0754717f, 0.025157232f, 0.056603774f, 0.031446543f, 0.0754717f, 0.094339624f, 0.0754717f, 0.031446543f, 0.025157232f, 0.056603774f, 0.0754717f, 0.025157232f, 0.056603774f, 0.012578616f, 0.025157232f, 0.031446543f, 0.025157232f, 0.012578616f};
    private float[] kernel = null;

    public ConvolutionFilter(float[] kernel) {
        this.kernel = kernel;
    }

    @Override
    public BufferedImage filter(BufferedImage input) {
        System.out.println("Convolution filter");
        int size = (int)Math.sqrt(this.kernel.length);
        ConvolveOp edge = new ConvolveOp(new Kernel(size, size, this.kernel));
        ColorModel cm = input.getColorModel();
        BufferedImage srccpy = edge.createCompatibleDestImage(input, cm);
        input.copyData(srccpy.getRaster());
        BufferedImage result = edge.createCompatibleDestImage(input, cm);
        return edge.filter(srccpy, result);
    }

    @Override
    public void filter(int width, int height, short[] source, short[] target) {
        ShortProcessor sp = new ShortProcessor(width, height, source, null);
        BufferedImage bi = new BufferedImage(width, height, 11);
        Graphics bg = bi.getGraphics();
        bg.drawImage(sp.createImage(), 0, 0, null);
        bg.dispose();
        ShortProcessor tp = new ShortProcessor(bi);
        System.arraycopy((short[])tp.getPixels(), 0, target, 0, target.length);
    }
}

