/*
 * Decompiled with CFR 0.152.
 */
package spimopener;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import spimopener.GaussianStackFocuser;
import spimopener.MaximumProjector;
import spimopener.MinimumProjector;
import spimopener.Projector;
import spimopener.SPIMRegularStack;
import spimopener.SPIMStack;
import spimopener.SPIMVirtualStack;
import spimopener.XMLReader;

public class SPIMExperiment {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int F = 2;
    public static final int Z = 3;
    public static final int T = 4;
    public final int sampleStart;
    public final int sampleEnd;
    public final int timepointStart;
    public final int timepointEnd;
    public final int regionStart;
    public final int regionEnd;
    public final int angleStart;
    public final int angleEnd;
    public final int channelStart;
    public final int channelEnd;
    public final int planeStart;
    public final int planeEnd;
    public final int frameStart;
    public final int frameEnd;
    public final String pathFormatString;
    public final double pw;
    public final double ph;
    public final double pd;
    public final int w;
    public final int h;
    public final int d;
    public final String[] samples;
    public final String[] regions;
    public final String[] angles;
    public final String[] channels;
    public final String experimentName;
    public static final int NO_PROJECTION = 0;
    public static final int MAX_PROJECTION = 1;
    public static final int MIN_PROJECTION = 2;
    public static final int GAUSSIAN_STACK_FOCUSER = 3;

    public SPIMExperiment(String xmlfile) {
        if (!xmlfile.endsWith(".xml")) {
            throw new IllegalArgumentException("Please select an xml file");
        }
        File experimentFolder = new File(xmlfile.substring(0, xmlfile.length() - 4));
        this.experimentName = experimentFolder.getParentFile().getName() + " - " + experimentFolder.getName();
        if (!(experimentFolder = new File(experimentFolder.getParent(), experimentFolder.getName())).exists() || !experimentFolder.isDirectory()) {
            throw new IllegalArgumentException("No directory " + experimentFolder.getAbsolutePath());
        }
        File tmp = new File(experimentFolder.getAbsolutePath());
        System.out.println(tmp.getAbsolutePath());
        this.samples = SPIMExperiment.filter(tmp.list(), "s\\d{3}?");
        Arrays.sort(this.samples);
        tmp = new File(tmp, this.samples[0]);
        Object[] timepoints = SPIMExperiment.filter(tmp.list(), "t\\d{5}?");
        Arrays.sort(timepoints);
        tmp = new File(tmp, (String)timepoints[0]);
        this.regions = SPIMExperiment.filter(tmp.list(), "r\\d{3}?");
        Arrays.sort(this.regions);
        tmp = new File(tmp, this.regions[0]);
        this.angles = SPIMExperiment.filter(tmp.list(), "a\\d{3}?");
        Arrays.sort(this.angles);
        tmp = new File(tmp, this.angles[0]);
        this.channels = SPIMExperiment.filter(tmp.list(), "c\\d{3}?");
        Arrays.sort(this.channels);
        tmp = new File(tmp, this.channels[0]);
        boolean zStack = false;
        Object[] planes = SPIMExperiment.filter(tmp.list(), "z\\d{4}?");
        if (planes.length == 0) {
            planes = SPIMExperiment.filter(tmp.list(), "zstack");
            zStack = true;
        }
        Arrays.sort(planes);
        tmp = new File(tmp, (String)planes[0]);
        Object[] frames = tmp.list();
        Arrays.sort(frames);
        this.sampleStart = SPIMExperiment.getMin(this.samples);
        this.sampleEnd = SPIMExperiment.getMax(this.samples);
        this.timepointStart = SPIMExperiment.getMin((String[])timepoints);
        this.timepointEnd = SPIMExperiment.getMax((String[])timepoints);
        this.regionStart = SPIMExperiment.getMin(this.regions);
        this.regionEnd = SPIMExperiment.getMax(this.regions);
        this.angleStart = SPIMExperiment.getMin(this.angles);
        this.angleEnd = SPIMExperiment.getMax(this.angles);
        this.channelStart = SPIMExperiment.getMin(this.channels);
        this.channelEnd = SPIMExperiment.getMax(this.channels);
        int zMin = 0;
        int zMax = 0;
        if (!zStack) {
            zMin = SPIMExperiment.getMin((String[])planes);
            zMax = SPIMExperiment.getMax((String[])planes);
        }
        int fMin = SPIMExperiment.getMin((String[])frames);
        int fMax = SPIMExperiment.getMax((String[])frames);
        if (((String)frames[0]).startsWith("plane_")) {
            this.pathFormatString = experimentFolder.getAbsolutePath() + File.separator + "s%03d/t%05d/r%03d/a%03d/c%03d/z0000/plane_%010d.dat";
            zMin = fMin;
            zMax = fMax;
            fMax = 0;
            fMin = 0;
        } else if (zStack) {
            this.pathFormatString = experimentFolder.getAbsolutePath() + File.separator + "s%03d/t%05d/r%03d/a%03d/c%03d/zstack/%010d.dat";
            zMin = fMin;
            zMax = fMax;
            fMax = 0;
            fMin = 0;
        } else {
            this.pathFormatString = experimentFolder.getAbsolutePath() + File.separator + "s%03d/t%05d/r%03d/a%03d/c%03d/z%04d/%010d.dat";
        }
        this.planeStart = zMin;
        this.planeEnd = zMax;
        this.frameStart = fMin;
        this.frameEnd = fMax;
        try {
            XMLReader xmlreader = new XMLReader(xmlfile);
            this.pw = xmlreader.pw;
            this.ph = xmlreader.ph;
            this.pd = xmlreader.pd;
            this.w = xmlreader.width;
            this.h = xmlreader.height;
            this.d = xmlreader.depth;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error reading xml file: " + xmlfile, e);
        }
    }

    public String getPath(int sample, int timepoint, int region, int angle, int channel, int plane, int frame) {
        return String.format(this.pathFormatString, sample, timepoint, region, angle, channel, plane, frame);
    }

    public ImagePlus open(int sample, int tpMin, int tpMax, int region, int angle, int channel, int zMin, int zMax, int fMin, int fMax, int projectionMethod, boolean virtual) {
        return this.open(sample, tpMin, tpMax, region, angle, channel, zMin, zMax, fMin, fMax, 0, this.h - 1, 0, this.w - 1, projectionMethod, virtual);
    }

    public ImagePlus open(int sample, int tpMin, int tpMax, int region, int angle, int channel, int zMin, int zMax, int fMin, int fMax, int yMin, int yMax, int xMin, int xMax, int projectionMethod, boolean virtual) {
        int xDir = 0;
        int yDir = 1;
        int projectionDir = 3;
        int nTp = tpMax - tpMin + 1;
        int nZ = zMax - zMin + 1;
        int nF = fMax - fMin + 1;
        int nDimensionsWithMoreThanOne = 0;
        int zDir = -1;
        if (nTp > 1) {
            zDir = 4;
            ++nDimensionsWithMoreThanOne;
        }
        if (nF > 1) {
            zDir = 2;
            ++nDimensionsWithMoreThanOne;
        }
        if (nZ > 1 && projectionMethod == 0) {
            zDir = 3;
            ++nDimensionsWithMoreThanOne;
        }
        if (nDimensionsWithMoreThanOne > 1) {
            throw new IllegalArgumentException("Only one dimension of time, plane and frame may contain an interval");
        }
        if (zDir == -1) {
            zDir = 4;
        }
        return this.open(sample, tpMin, tpMax, region, angle, channel, zMin, zMax, fMin, fMax, yMin, yMax, xMin, xMax, xDir, yDir, zDir, virtual, projectionMethod, projectionDir);
    }

    public ImagePlus open(int sample, int tpMin, int tpMax, int region, int angle, int channel, int zMin, int zMax, int fMin, int fMax, int yMin, int yMax, int xMin, int xMax, int xDir, int yDir, int zDir, boolean virtual, int projectionMethod, int projectionDir) {
        return this.open(sample, tpMin, tpMax, 1, region, angle, channel, zMin, zMax, 1, fMin, fMax, 1, yMin, yMax, 1, xMin, xMax, 1, xDir, yDir, zDir, virtual, projectionMethod, projectionDir);
    }

    public ImagePlus open(int sample, int tpMin, int tpMax, int tpStep, int region, int angle, int channel, int zMin, int zMax, int zStep, int fMin, int fMax, int fStep, int yMin, int yMax, int yStep, int xMin, int xMax, int xStep, int xDir, int yDir, int zDir, boolean virtual, int projectionMethod, int projectionDir) {
        ShortProcessor ip;
        if (projectionMethod == 0) {
            return this.openNotProjected(sample, tpMin, tpMax, tpStep, region, angle, channel, zMin, zMax, zStep, fMin, fMax, fStep, yMin, yMax, yStep, xMin, xMax, xStep, xDir, yDir, zDir, virtual);
        }
        Projector projector = null;
        switch (projectionMethod) {
            case 2: {
                projector = new MinimumProjector();
                break;
            }
            case 1: {
                projector = new MaximumProjector();
                break;
            }
            case 3: {
                projector = new GaussianStackFocuser();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown projection method: " + projectionMethod);
            }
        }
        int D = 5;
        int[] MIN = new int[]{xMin, yMin, fMin, zMin, tpMin};
        int[] MAX = new int[]{xMax, yMax, fMax, zMax, tpMax};
        int[] INC = new int[]{xStep, yStep, fStep, zStep, tpStep};
        if (projectionDir == xDir) {
            throw new IllegalArgumentException("The projection direction cannot be the same as the dimension displayed in x direction");
        }
        if (projectionDir == yDir) {
            throw new IllegalArgumentException("The projection direction cannot be the same as the dimension displayed in y direction");
        }
        if (projectionDir == zDir) {
            throw new IllegalArgumentException("The projection direction cannot be the same as the dimension displayed in z direction");
        }
        if ((MAX[projectionDir] - MIN[projectionDir] + 1) / INC[projectionDir] <= 1) {
            return this.openNotProjected(sample, tpMin, tpMax, tpStep, region, angle, channel, zMin, zMax, zStep, fMin, fMax, fStep, yMin, yMax, yStep, xMin, xMax, xStep, xDir, yDir, zDir, virtual);
        }
        int ws = (MAX[xDir] - MIN[xDir] + 1) / INC[xDir];
        int hs = (MAX[yDir] - MIN[yDir] + 1) / INC[yDir];
        SPIMStack stack = virtual ? new SPIMVirtualStack(ws, hs) : new SPIMRegularStack(ws, hs);
        int[] position = new int[5];
        System.arraycopy(MIN, 0, position, 0, 5);
        if (xDir == 0 && yDir == 1 && INC[xDir] == 1 && INC[yDir] == 1) {
            for (int z = MIN[zDir]; z <= MAX[zDir]; z += INC[zDir]) {
                position[zDir] = z;
                if (IJ.escapePressed()) {
                    IJ.resetEscape();
                    break;
                }
                projector.reset();
                for (int proj = MIN[projectionDir]; proj <= MAX[projectionDir]; proj += INC[projectionDir]) {
                    position[projectionDir] = proj;
                    String path = this.getPath(sample, position[4], region, angle, channel, position[3], position[2]);
                    ip = SPIMExperiment.openRaw(path, this.w, this.h, MIN[xDir], MAX[xDir], MIN[yDir], MAX[yDir]);
                    projector.add((ImageProcessor)ip);
                }
                stack.addSlice(projector.getProjection());
                IJ.showProgress((int)(z - MIN[zDir]), (int)(MAX[zDir] - MIN[zDir] + 1));
            }
        } else {
            int[] ordered = new int[]{Math.min(xDir, yDir), Math.max(xDir, yDir)};
            for (int z = MIN[zDir]; z <= MAX[zDir]; z += INC[zDir]) {
                position[zDir] = z;
                if (IJ.escapePressed()) {
                    IJ.resetEscape();
                    break;
                }
                projector.reset();
                for (int proj = MIN[projectionDir]; proj <= MAX[projectionDir]; proj += INC[projectionDir]) {
                    position[projectionDir] = proj;
                    ip = new ShortProcessor(ws, hs);
                    for (int i1 = MIN[ordered[1]]; i1 <= MAX[ordered[1]]; i1 += INC[ordered[1]]) {
                        position[ordered[1]] = i1;
                        String path = this.getPath(sample, position[4], region, angle, channel, position[3], position[2]);
                        ImageProcessor org = SPIMExperiment.openRaw(path, this.w, this.h);
                        for (int i2 = MIN[ordered[0]]; i2 <= MAX[ordered[0]]; i2 += INC[ordered[0]]) {
                            position[ordered[0]] = i2;
                            ip.set((position[xDir] - MIN[xDir]) / INC[xDir], (position[yDir] - MIN[yDir]) / INC[yDir], org.get(position[0], position[1]));
                        }
                    }
                    projector.add((ImageProcessor)ip);
                }
                stack.addSlice(projector.getProjection());
                System.out.println(z - MIN[zDir] + " / " + (MAX[zDir] - MIN[zDir] + 1));
                IJ.showProgress((int)(z - MIN[zDir]), (int)(MAX[zDir] - MIN[zDir] + 1));
            }
        }
        IJ.showProgress((double)1.0);
        double[] pdiffs = new double[]{this.pw, this.ph, 1.0, this.pd, 1.0};
        for (int i = 0; i < pdiffs.length; ++i) {
            int n = i;
            pdiffs[n] = pdiffs[n] * (double)INC[i];
        }
        ImagePlus ret = new ImagePlus(this.experimentName, (ImageStack)stack);
        ret.getCalibration().pixelWidth = pdiffs[xDir];
        ret.getCalibration().pixelHeight = pdiffs[yDir];
        ret.getCalibration().pixelDepth = pdiffs[zDir];
        return ret;
    }

    public ImagePlus openNotProjected(int sample, int tpMin, int tpMax, int region, int angle, int channel, int zMin, int zMax, int fMin, int fMax, int yMin, int yMax, int xMin, int xMax, int xDir, int yDir, int zDir, boolean virtual) {
        return this.openNotProjected(sample, tpMin, tpMax, region, angle, channel, zMin, zMax, 1, fMin, fMax, yMin, yMax, xMin, xMax, xDir, yDir, zDir, virtual);
    }

    public ImagePlus openNotProjected(int sample, int tpMin, int tpMax, int region, int angle, int channel, int zMin, int zMax, int zStep, int fMin, int fMax, int yMin, int yMax, int xMin, int xMax, int xDir, int yDir, int zDir, boolean virtual) {
        return this.openNotProjected(sample, tpMin, tpMax, 1, region, angle, channel, zMin, zMax, zStep, fMin, fMax, 1, yMin, yMax, 1, xMin, xMax, 1, xDir, yDir, zDir, virtual);
    }

    public ImagePlus openNotProjected(int sample, int tpMin, int tpMax, int tpStep, int region, int angle, int channel, int zMin, int zMax, int zStep, int fMin, int fMax, int fStep, int yMin, int yMax, int yStep, int xMin, int xMax, int xStep, int xDir, int yDir, int zDir, boolean virtual) {
        int D = 5;
        int[] MIN = new int[]{xMin, yMin, fMin, zMin, tpMin};
        int[] MAX = new int[]{xMax, yMax, fMax, zMax, tpMax};
        int[] INC = new int[]{xStep, yStep, fStep, zStep, tpStep};
        int ws = (MAX[xDir] - MIN[xDir] + 1) / INC[xDir];
        int hs = (MAX[yDir] - MIN[yDir] + 1) / INC[yDir];
        SPIMStack stack = virtual ? new SPIMVirtualStack(ws, hs) : new SPIMRegularStack(ws, hs);
        int[] position = new int[5];
        System.arraycopy(MIN, 0, position, 0, 5);
        if (xDir == 0 && yDir == 1 && INC[xDir] == 1 && INC[yDir] == 1) {
            stack.setRange(this.w, this.h, MIN[xDir], MIN[yDir]);
            for (int z = MIN[zDir]; z <= MAX[zDir]; z += INC[zDir]) {
                if (IJ.escapePressed()) {
                    IJ.resetEscape();
                    break;
                }
                position[zDir] = z;
                String path = this.getPath(sample, position[4], region, angle, channel, position[3], position[2]);
                stack.addSlice(path);
                IJ.showProgress((int)(z - MIN[zDir]), (int)(MAX[zDir] - MIN[zDir] + 1));
            }
        } else {
            int[] ordered = new int[]{Math.min(xDir, yDir), Math.max(xDir, yDir)};
            for (int z = MIN[zDir]; z <= MAX[zDir]; z += INC[zDir]) {
                if (IJ.escapePressed()) {
                    IJ.resetEscape();
                    break;
                }
                position[zDir] = z;
                ShortProcessor ip = new ShortProcessor(ws, hs);
                for (int i1 = MIN[ordered[1]]; i1 <= MAX[ordered[1]]; i1 += INC[ordered[1]]) {
                    position[ordered[1]] = i1;
                    String path = this.getPath(sample, position[4], region, angle, channel, position[3], position[2]);
                    ImageProcessor org = SPIMExperiment.openRaw(path, this.w, this.h);
                    for (int i2 = MIN[ordered[0]]; i2 <= MAX[ordered[0]]; i2 += INC[ordered[0]]) {
                        position[ordered[0]] = i2;
                        ip.set((position[xDir] - MIN[xDir]) / INC[xDir], (position[yDir] - MIN[yDir]) / INC[yDir], org.get(position[0], position[1]));
                    }
                }
                stack.addSlice((ImageProcessor)ip);
                System.out.println(z - MIN[zDir] + " / " + (MAX[zDir] - MIN[zDir] + 1));
                IJ.showProgress((int)(z - MIN[zDir]), (int)(MAX[zDir] - MIN[zDir] + 1));
            }
        }
        IJ.showProgress((double)1.0);
        double[] pdiffs = new double[]{this.pw, this.ph, 1.0, this.pd, 1.0};
        for (int i = 0; i < pdiffs.length; ++i) {
            int n = i;
            pdiffs[n] = pdiffs[n] * (double)INC[i];
        }
        ImagePlus ret = new ImagePlus(this.experimentName, (ImageStack)stack);
        ret.getCalibration().pixelWidth = pdiffs[xDir];
        ret.getCalibration().pixelHeight = pdiffs[yDir];
        ret.getCalibration().pixelDepth = pdiffs[zDir];
        return ret;
    }

    public static ImageProcessor openRaw(String path, int orgW, int orgH, int xMin, int xMax, int yMin, int yMax) {
        if (xMin == 0 && xMax == orgW - 1 && yMin == 0 && yMax == orgH - 1) {
            return SPIMExperiment.openRaw(path, orgW, orgH);
        }
        int ws = xMax - xMin + 1;
        int hs = yMax - yMin + 1;
        byte[] bytes = new byte[ws * hs * 2];
        short[] pixels = new short[ws * hs];
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
            int toSkip = 2 * (yMin * orgW + xMin);
            while (toSkip > 0) {
                toSkip = (int)((long)toSkip - in.skip(toSkip));
            }
            int offs = 0;
            for (int r = 0; r < hs; ++r) {
                for (int read = 0; read < ws; read += in.read(bytes, offs + read, 2 * ws - read)) {
                }
                offs += 2 * ws;
                toSkip = 2 * (orgW - xMax - 1 + xMin);
                while (toSkip > 0) {
                    toSkip = (int)((long)toSkip - in.skip(toSkip));
                }
            }
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load " + path, e);
        }
        for (int i = 0; i < pixels.length; ++i) {
            int low = 0xFF & bytes[2 * i];
            int high = 0xFF & bytes[2 * i + 1];
            pixels[i] = (short)(high << 8 | low);
        }
        return new ShortProcessor(ws, hs, pixels, null);
    }

    public static ImageProcessor openRaw(String path, int w, int h) {
        byte[] bytes = new byte[w * h * 2];
        short[] pixels = new short[w * h];
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
            for (int read = 0; read < bytes.length; read += in.read(bytes, read, bytes.length - read)) {
            }
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load " + path, e);
        }
        for (int i = 0; i < pixels.length; ++i) {
            int low = 0xFF & bytes[2 * i];
            int high = 0xFF & bytes[2 * i + 1];
            pixels[i] = (short)(high << 8 | low);
        }
        return new ShortProcessor(w, h, pixels, null);
    }

    public static void saveRaw(ImageProcessor ip, String path) {
        short[] pixels = (short[])ip.getPixels();
        byte[] bytes = new byte[pixels.length * 2];
        for (int i = 0; i < pixels.length; ++i) {
            short pixel = pixels[i];
            bytes[2 * i] = (byte)pixel;
            bytes[2 * i + 1] = (byte)(pixel >> 8);
        }
        try {
            FileOutputStream out = new FileOutputStream(path);
            out.write(bytes);
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot save to " + path, e);
        }
    }

    private static String[] filter(String[] in, String pattern) {
        ArrayList<String> all = new ArrayList<String>(in.length);
        for (String s : in) {
            if (!s.matches(pattern)) continue;
            all.add(s);
        }
        String[] out = new String[all.size()];
        all.toArray(out);
        return out;
    }

    private static int getMin(String[] s) {
        int idx = 0;
        int start = s[idx].startsWith("plane_") ? 6 : 1;
        int stop = s[idx].indexOf(46) >= 0 ? s[idx].length() - 4 : s[idx].length();
        return Integer.parseInt(s[idx].substring(start, stop));
    }

    private static int getMax(String[] s) {
        int idx = s.length - 1;
        int start = s[idx].startsWith("plane_") ? 6 : 1;
        int stop = s[idx].indexOf(46) >= 0 ? s[idx].length() - 4 : s[idx].length();
        return Integer.parseInt(s[idx].substring(start, stop));
    }
}

