/*
 * Decompiled with CFR 0.152.
 */
package spimopener;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class DoubleSlider
extends Panel
implements TextListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private TextField minTF = new TextField(4);
    private TextField maxTF = new TextField(4);
    private TextField incTF = new TextField(4);
    private DoubleSliderCanvas slider;

    public DoubleSlider(int min, int max, int cmin, int cmax) {
        this.minTF.addTextListener(this);
        this.minTF.addFocusListener(this);
        this.maxTF.addTextListener(this);
        this.maxTF.addFocusListener(this);
        this.slider = new DoubleSliderCanvas(min, max, cmin, cmax, this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(0, 2, 0, 5);
        c.weightx = 1.0;
        this.add((Component)this.slider, c);
        c.weightx = 0.0;
        this.add((Component)this.minTF, c);
        this.add((Component)this.maxTF, c);
        this.incTF.setText("1");
        this.add((Component)this.incTF, c);
        this.valueChanged();
    }

    @Override
    public void focusGained(FocusEvent e) {
        TextField tf = (TextField)e.getSource();
        tf.selectAll();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void textValueChanged(TextEvent e) {
        try {
            int min = Integer.parseInt(this.minTF.getText());
            int max = Integer.parseInt(this.maxTF.getText());
            this.slider.setRange(min, max);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void valueChanged() {
        this.minTF.setText(Integer.toString(this.slider.cmin));
        this.maxTF.setText(Integer.toString(this.slider.cmax));
    }

    public int getCurrentMin() {
        return this.slider.cmin;
    }

    public int getCurrentMax() {
        return this.slider.cmax;
    }

    public int getIncrement() {
        return Integer.parseInt(this.incTF.getText());
    }

    private static class DoubleSliderCanvas
    extends Component
    implements MouseMotionListener,
    MouseListener {
        private static final long serialVersionUID = 1L;
        private int min;
        private int max;
        private int cmin;
        private int cmax;
        private int drawnMin;
        private int drawnMax;
        private int dragging = 0;
        private static final int DRAGGING_NONE = 0;
        private static final int DRAGGING_LEFT = 1;
        private static final int DRAGGING_RIGHT = 2;
        private DoubleSlider slider;

        public DoubleSliderCanvas(int min, int max, int cmin, int cmax, DoubleSlider slider) {
            this.min = min;
            this.max = max;
            this.cmin = cmin;
            this.cmax = cmax;
            this.slider = slider;
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.setPreferredSize(new Dimension(200, 30));
        }

        public void setRange(int cmin, int cmax) {
            this.cmin = cmin;
            this.cmax = cmax;
            this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            double inc = (double)this.getWidth() / (double)(this.max - this.min + 1);
            int newx = (int)Math.round((double)e.getX() / inc) + this.min;
            switch (this.dragging) {
                case 1: {
                    this.cmin = Math.max(this.min, Math.min(this.cmax, newx));
                    this.repaint();
                    this.slider.valueChanged();
                    break;
                }
                case 2: {
                    this.cmax = Math.min(this.max, Math.max(this.cmin, newx - 1));
                    this.repaint();
                    this.slider.valueChanged();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            if (Math.abs(x - this.drawnMin) < 10) {
                this.setCursor(new Cursor(10));
                this.dragging = 1;
            } else if (Math.abs(x - this.drawnMax) < 10) {
                this.setCursor(new Cursor(11));
                this.dragging = 2;
            } else {
                this.setCursor(new Cursor(0));
                this.dragging = 0;
            }
        }

        @Override
        public void paint(Graphics g) {
            int w = this.getWidth();
            int h = this.getHeight();
            double inc = (double)w / (double)(this.max - this.min + 1);
            this.drawnMin = (int)Math.round((double)(this.cmin - this.min) * inc);
            this.drawnMax = (int)Math.round((double)(this.cmax + 1 - this.min) * inc);
            g.setColor(Color.GREEN);
            g.fillRect(this.drawnMin, 0, this.drawnMax - this.drawnMin, h);
            g.setColor(Color.BLACK);
            g.drawRect(0, 0, w - 1, h - 1);
        }
    }
}

