/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.imglib2.util.StopWatch;

public class TimeStatistics {
    private static final List<AverageTime> times = new ArrayList<AverageTime>();
    public static AverageTime a = TimeStatistics.newAverageTime("measurement a");
    public static AverageTime b = TimeStatistics.newAverageTime("measurement b");
    public static AverageTime c = TimeStatistics.newAverageTime("measurement c");
    public static AverageTime d = TimeStatistics.newAverageTime("measurement d");

    private static synchronized AverageTime newAverageTime(String title) {
        AverageTime n = new AverageTime(title);
        times.add(n);
        return n;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.err.println("Average Times");
            for (AverageTime time : times) {
                System.err.println(time);
            }
        }));
    }

    private static class Average {
        AtomicLong nanoSeconds = new AtomicLong(0L);
        AtomicLong counter = new AtomicLong(0L);

        private Average() {
        }

        public void addValue(long value) {
            this.nanoSeconds.addAndGet(value);
            this.counter.incrementAndGet();
        }

        public double getAverage() {
            return (double)this.nanoSeconds.get() / (double)this.counter.get();
        }
    }

    public static interface Timer {
        public void stop();
    }

    public static class AverageTime {
        private final String title;
        private final Average average = new Average();

        public AverageTime(String title) {
            this.title = title;
        }

        public Timer startTimer() {
            long start = System.nanoTime();
            return () -> this.average.addValue(System.nanoTime() - start);
        }

        public double getSeconds() {
            return this.average.getAverage() * 1.0E-9;
        }

        public String toString() {
            return this.title + ": " + StopWatch.secondsToString((double)this.getSeconds());
        }
    }
}

