/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.random_forest;

import java.lang.reflect.Field;
import net.imglib2.util.Cast;

class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> T getPrivateField(Object object, String fieldName, Class<T> type) {
        try {
            Class<?> clazz = object.getClass();
            Field field = ReflectionUtils.getField(clazz, fieldName);
            field.setAccessible(true);
            return (T)Cast.unchecked((Object)field.get(object));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                return ReflectionUtils.getField(superclass, fieldName);
            }
            throw e;
        }
    }
}

