/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.fs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.fs.DBFFileSystemManager;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystem;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithCache;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystem;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystemRoot;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.ArrayUtils;

public class DBNFileSystems
extends DBNNode
implements DBNNodeWithCache,
DBPHiddenObject {
    private DBNFileSystem[] children;

    public DBNFileSystems(DBNProject parentNode) {
        super(parentNode);
    }

    @Override
    protected void dispose(boolean reflect) {
        super.dispose(reflect);
        this.disposeFileSystems();
    }

    @Override
    @NotNull
    public String getNodeType() {
        return DBNNode.NodePathType.dbvfs.name();
    }

    @Override
    @NotNull
    public String getNodeId() {
        return DBNNode.NodePathType.dbvfs.name();
    }

    @Override
    @NotNull
    public String getNodeTypeLabel() {
        return ModelMessages.fs_root;
    }

    @Override
    @Property(id="name", viewable=true, order=1)
    @NotNull
    public String getNodeDisplayName() {
        return "Remote file systems";
    }

    @Override
    @NotNull
    public String getName() {
        return DBNNode.NodePathType.dbvfs.name();
    }

    @Override
    @Nullable
    public String getNodeDescription() {
        return "All virtual file systems";
    }

    @Override
    @Nullable
    public DBPImage getNodeIcon() {
        return DBIcon.TREE_FILE;
    }

    @Override
    public boolean allowsChildren() {
        return true;
    }

    public DBNFileSystem getFileSystem(@Nullable String type, @NotNull String id) {
        if (this.children == null) {
            return null;
        }
        DBNFileSystem[] dBNFileSystemArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            DBNFileSystem fsNode = dBNFileSystemArray[n2];
            DBFVirtualFileSystem fs = fsNode.getFileSystem();
            if ((type == null || fs.getType().equals(type)) && fs.getId().equals(id)) {
                return fsNode;
            }
            ++n2;
        }
        return null;
    }

    public DBNFileSystemRoot getRootFolder(@NotNull DBRProgressMonitor monitor, @NotNull String id) throws DBException {
        for (DBNFileSystem fsNode : ArrayUtils.safeArray((Object[])this.getChildren(monitor))) {
            DBNFileSystemRoot rootFolder = fsNode.getChild(monitor, id);
            if (rootFolder == null) continue;
            return rootFolder;
        }
        return null;
    }

    @Nullable
    public DBNFileSystem[] getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.children == null && !monitor.isForceCacheUsage()) {
            try {
                this.children = this.readChildNodes(monitor, this.children);
            }
            catch (DBException e) {
                this.children = new DBNFileSystem[0];
                throw e;
            }
        }
        return this.children;
    }

    protected DBNFileSystem[] readChildNodes(@NotNull DBRProgressMonitor monitor, @Nullable DBNFileSystem[] mergeWith) throws DBException {
        monitor.beginTask("Read available file systems", 1);
        ArrayList<DBNFileSystem> result = new ArrayList<DBNFileSystem>();
        DBPProject project = this.getOwnerProject();
        if (project == null) {
            return new DBNFileSystem[0];
        }
        DBFFileSystemManager fileSystemManager = project.getFileSystemManager();
        for (DBFVirtualFileSystem fs : fileSystemManager.getVirtualFileSystems(monitor)) {
            DBNFileSystem newChild = null;
            if (mergeWith != null) {
                DBNFileSystem[] dBNFileSystemArray = mergeWith;
                int n = mergeWith.length;
                int n2 = 0;
                while (n2 < n) {
                    DBNFileSystem oldFS = dBNFileSystemArray[n2];
                    if (this.equalsFS(fs, oldFS.getFileSystem())) {
                        newChild = oldFS;
                        break;
                    }
                    ++n2;
                }
            }
            if (newChild == null) {
                newChild = new DBNFileSystem(this, fs);
            }
            result.add(newChild);
        }
        result.sort((o1, o2) -> o1.getNodeDisplayName().compareToIgnoreCase(o2.getNodeDisplayName()));
        monitor.done();
        return result.toArray(new DBNFileSystem[0]);
    }

    private boolean equalsFS(DBFVirtualFileSystem fs1, DBFVirtualFileSystem fs2) {
        return fs1.getType().equals(fs2.getType()) && fs1.getId().equals(fs2.getId());
    }

    public DBNPathBase findNodeByPath(@NotNull DBRProgressMonitor monitor, @NotNull String path) throws DBException {
        return this.findNodeByPath(monitor, path, false);
    }

    public DBNPathBase findNodeByPath(@NotNull DBRProgressMonitor monitor, @NotNull String path, boolean shortPath) throws DBException {
        String plainPath;
        int divPos;
        URI uri;
        DBNNode curPath = null;
        try {
            uri = new URI(path);
        }
        catch (URISyntaxException e) {
            throw new DBException("Bad path: " + path, e);
        }
        String fsId = DBFUtils.getQueryParameters(uri.getRawQuery()).get("fs");
        if (fsId != null) {
            curPath = this.getFileSystem(uri.getScheme(), fsId);
        }
        if ((divPos = (plainPath = uri.getSchemeSpecificPart()).lastIndexOf(63)) != -1) {
            plainPath = plainPath.substring(0, divPos);
        }
        String[] stringArray = plainPath.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!name.isEmpty()) {
                if (curPath == null) {
                    this.getChildren(monitor);
                    curPath = !shortPath ? this.getFileSystem(uri.getScheme(), name) : this.getRootFolder(monitor, name);
                } else if (curPath instanceof DBNFileSystem) {
                    DBNFileSystem fsNode = curPath;
                    fsNode.getChildren(monitor);
                    curPath = fsNode.getRoot(name);
                } else {
                    DBNPathBase pathNode = (DBNPathBase)curPath;
                    pathNode.getChildren(monitor);
                    curPath = pathNode.getChild(name);
                }
                if (curPath == null) {
                    return null;
                }
            }
            ++n2;
        }
        return curPath instanceof DBNPathBase ? (DBNPathBase)curPath : null;
    }

    @Override
    public boolean isManageable() {
        return true;
    }

    @Override
    @Nullable
    public DBNNode refreshNode(@NotNull DBRProgressMonitor monitor, @Nullable Object source) throws DBException {
        this.refreshFileSystems(monitor);
        return this;
    }

    private void refreshFileSystems(DBRProgressMonitor monitor) throws DBException {
        if (this.children != null) {
            this.children = this.readChildNodes(monitor, this.children);
            this.getModel().fireNodeUpdate(this, this, DBNEvent.NodeChange.REFRESH);
        }
    }

    private void disposeFileSystems() {
        if (this.children != null) {
            DBNFileSystem[] dBNFileSystemArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                DBNFileSystem fs = dBNFileSystemArray[n2];
                DBNUtils.disposeNode(fs, false);
                ++n2;
            }
            this.children = null;
        }
    }

    @Override
    @Deprecated
    @NotNull
    public String getNodeItemPath() {
        return DBNNode.NodePathType.ext.getPrefix() + ((DBNProject)this.getParentNode()).getProject().getId() + "/" + this.getName();
    }

    @Override
    public boolean supportsRename() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        return "FileSystems(" + this.getOwnerProject().getName() + ")";
    }

    @Override
    public boolean needsInitialization() {
        return this.children == null;
    }

    public DBNFileSystem[] getCachedChildren() {
        return this.children;
    }

    @Override
    public void setCachedChildren(DBNNode[] children) {
    }
}

