/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.launching;

import java.util.Map;
import melnorme.lang.ide.core.EclipseCore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;

public class RuntimeProcessExtension
extends RuntimeProcess {
    public RuntimeProcessExtension(ILaunch launch, Process process, String name, Map<String, String> attributes) {
        super(launch, process, name, attributes);
    }

    protected void fireTerminateEvent() {
        this.updateProcessLabelForConsole();
        super.fireTerminateEvent();
    }

    protected void updateProcessLabelForConsole() {
        this.setAttribute(IProcess.ATTR_PROCESS_LABEL, RuntimeProcessExtension.calcExtendedProcessLabel((IProcess)this));
    }

    public static String calcExtendedProcessLabel(IProcess process) {
        ILaunchConfiguration launchConfiguration;
        ILaunch launch = process.getLaunch();
        StringBuffer buffer = new StringBuffer();
        if (process.isTerminated()) {
            try {
                int exitValue = process.getExitValue();
                buffer.append("<exit code: " + exitValue + "> ");
            }
            catch (DebugException exitValue) {
                // empty catch block
            }
        }
        if ((launchConfiguration = launch.getLaunchConfiguration()) != null) {
            buffer.append(launchConfiguration.getName());
            try {
                ILaunchConfigurationType launchConfigType = launchConfiguration.getType();
                if (launchConfigType != null) {
                    String type = launchConfigType.getName();
                    buffer.append(" [");
                    buffer.append(type);
                    buffer.append("] ");
                }
            }
            catch (CoreException ce) {
                EclipseCore.logStatus(ce);
            }
        }
        buffer.append(process.getLabel());
        return buffer.toString();
    }
}

