/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.launching;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.launch.BuildTargetLaunchCreator;
import melnorme.lang.ide.core.launch.BuildTargetSource;
import melnorme.lang.ide.core.launch.CompositeBuildTargetSettings;
import melnorme.lang.ide.core.launch.LaunchMessages;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.operations.build.BuildTarget;
import melnorme.lang.ide.core.operations.build.CompositeBuildOperation;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.core.utils.ProjectValidator;
import melnorme.lang.ide.launching.EclipseProcessLauncher;
import melnorme.lang.tooling.commands.CommandInvocation;
import melnorme.lang.tooling.common.ops.Operation;
import melnorme.utilbox.collections.HashMap2;
import melnorme.utilbox.collections.MapAccess;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.Location;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;

public abstract class LangLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    protected CompositeBuildTargetSettings buildTargetSettings;
    protected EclipseProcessLauncher processLauncher;

    protected CoreException error(String message, Throwable exception) throws CoreException {
        throw EclipseCore.createCoreException(message, exception);
    }

    protected CoreException errorMsg(String messagePattern, Object ... arguments) throws CoreException {
        throw this.error(MessageFormat.format(messagePattern, arguments), null);
    }

    public final ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        try {
            this.buildTargetSettings = this.getBuildTargetSettings(configuration);
            this.processLauncher = this.getValidLaunchInfo(configuration, this.buildTargetSettings);
        }
        catch (CommonException ce) {
            throw EclipseCore.createCoreException(ce);
        }
        if ("run".equals(mode)) {
            return this.getLaunchForRunMode(configuration, mode);
        }
        if ("debug".equals(mode)) {
            return this.getLaunchForDebugMode(configuration, mode);
        }
        throw this.abort_UnsupportedMode(mode);
    }

    protected CoreException abort_UnsupportedMode(String mode) throws CoreException {
        return this.errorMsg("Unsupported run mode: {0}", mode);
    }

    protected ILaunch getLaunchForRunMode(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new Launch(configuration, mode, null);
    }

    protected ILaunch getLaunchForDebugMode(ILaunchConfiguration configuration, String mode) throws CoreException {
        throw this.abort_UnsupportedMode(mode);
    }

    protected CompositeBuildTargetSettings getBuildTargetSettings(ILaunchConfiguration configuration) throws CoreException, CommonException {
        final BuildTargetLaunchCreator launchSettings = new BuildTargetLaunchCreator(configuration);
        BuildTargetSource buildTargetSource = new BuildTargetSource(){

            @Override
            public ProjectValidator getProjectValidator() {
                return new ProjectValidator();
            }

            @Override
            public String getProjectName() {
                return launchSettings.projectName;
            }

            @Override
            public String getBuildTargetName() {
                return launchSettings.getTargetName();
            }
        };
        return new CompositeBuildTargetSettings(buildTargetSource){

            @Override
            public String getExecutablePath() {
                return launchSettings.getExecutablePath();
            }

            @Override
            public CommandInvocation getBuildCommand() {
                return launchSettings.getBuildCommand();
            }
        };
    }

    protected EclipseProcessLauncher getValidLaunchInfo(ILaunchConfiguration configuration, CompositeBuildTargetSettings buildTargetSettings) throws CommonException, CoreException {
        BuildManager buildManager = LangCore.getBuildManager();
        IProject project = buildTargetSettings.getBuildTargetSupplier().getValidProject();
        BuildTarget buildTarget = buildTargetSettings.getValidBuildTarget();
        CompositeBuildOperation buildOperation = buildTarget == null ? null : buildManager.newBuildTargetOperation(project, buildTarget);
        String workingDirectoryString = this.evaluateStringVars(configuration.getAttribute("workingDir", null));
        IPath workingDirectory = workingDirectoryString == null ? project.getLocation() : new Path(workingDirectoryString);
        Location programLoc = buildTarget.getValidExecutableLocation();
        String programArguments = configuration.getAttribute("programArguments", "");
        String commandLine = String.valueOf(programLoc.toString()) + " " + programArguments;
        Map configEnv = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, new HashMap(0));
        boolean appendEnv = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        CommandInvocation programInvocation = new CommandInvocation(commandLine, (MapAccess)new HashMap2(configEnv), appendEnv);
        return new EclipseProcessLauncher(project, buildOperation, programLoc, workingDirectory, programInvocation, "GoProcess");
    }

    public final boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.subTask("Preparing launch...");
        }
        this.doPreLaunchCheck(configuration, mode, monitor);
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    protected IStringVariableManager getVariableManager() {
        return VariablesPlugin.getDefault().getStringVariableManager();
    }

    protected String evaluateStringVars(String expression) throws CoreException {
        if (expression == null) {
            return null;
        }
        return this.getVariableManager().performStringSubstitution(expression);
    }

    protected boolean doPreLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return (IProject[])CoreUtil.array((Object[])new IProject[]{this.processLauncher.project});
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        try {
            return this.doBuildForLaunch(configuration, mode, monitor);
        }
        catch (CommonException e) {
            throw EclipseCore.createCoreException(e);
        }
        catch (OperationCancellation e) {
            throw new OperationCanceledException();
        }
    }

    protected boolean doBuildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor pm) throws CoreException, CommonException, OperationCancellation {
        Operation buildOperation = this.processLauncher.buildOperation;
        if (buildOperation != null) {
            buildOperation.execute(EclipseUtils.om(pm));
            return false;
        }
        return super.buildForLaunch(configuration, mode, pm);
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return (IProject[])CoreUtil.array((Object[])new IProject[]{this.processLauncher.project});
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)LaunchMessages.LCD_StartingLaunchConfiguration(configuration.getName()), (int)10);
        try {
            this.launchProcess(configuration, launch, (IProgressMonitor)subMonitor.split(10));
        }
        catch (CommonException ce) {
            throw EclipseCore.createCoreException(ce);
        }
    }

    protected void launchProcess(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException, CommonException {
        this.processLauncher.launchProcess(launch);
    }
}

