/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.launching;

import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.operations.build.VariablesResolver;
import melnorme.lang.ide.launching.RuntimeProcessExtension;
import melnorme.lang.tooling.commands.CommandInvocation;
import melnorme.lang.tooling.commands.IVariablesResolver;
import melnorme.lang.tooling.common.ops.Operation;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.StringUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;

public class EclipseProcessLauncher {
    public final IProject project;
    public final Operation buildOperation;
    public final Location programFileLocation;
    public final IPath workingDir;
    public final CommandInvocation unresolvedProgramInvocation;
    public String processType;
    protected static final DateFormat PROCESS_LABEL_DATE_FORMAT = DateFormat.getDateTimeInstance(2, 2);

    public EclipseProcessLauncher(IProject project, Operation buildOperation, Location programFileLocation, IPath workingDir, CommandInvocation unresolvedProgramInvocation, String processType) {
        this.project = (IProject)Assert.AssertNamespace.assertNotNull((Object)project);
        this.buildOperation = buildOperation;
        this.programFileLocation = (Location)Assert.AssertNamespace.assertNotNull((Object)programFileLocation);
        this.workingDir = workingDir;
        this.unresolvedProgramInvocation = (CommandInvocation)Assert.AssertNamespace.assertNotNull((Object)unresolvedProgramInvocation);
        this.processType = processType;
    }

    protected CoreException abort(String message, Throwable exception) throws CoreException {
        throw EclipseCore.createCoreException(message, exception);
    }

    protected CoreException fail(String messagePattern, Object ... arguments) throws CoreException {
        throw this.abort(MessageFormat.format(messagePattern, arguments), null);
    }

    protected IProcess launchProcess(ILaunch launch) throws CoreException, CommonException {
        if (this.workingDir != null && !this.workingDir.toFile().exists()) {
            this.fail("Working directory ({0}) doesn't exist.", this.workingDir);
        }
        if (!this.programFileLocation.toFile().exists()) {
            this.fail("Executable file ({0}) doesn't exist.", this.programFileLocation);
        }
        CommandInvocation programInvocation = this.unresolvedProgramInvocation.getResolvedCommandInvocation((IVariablesResolver)new VariablesResolver(VariablesPlugin.getDefault().getStringVariableManager()));
        Indexable cmdLine = programInvocation.parseCommandLineArguments();
        Process sp = this.newSystemProcess(programInvocation);
        return this.newEclipseProcessWithLabelUpdater(launch, (Indexable<String>)cmdLine, sp);
    }

    protected Process newSystemProcess(CommandInvocation resolvedProgramInvocation) throws CoreException {
        ProcessBuilder processBuilder = resolvedProgramInvocation.getProcessBuilder();
        if (this.workingDir != null) {
            processBuilder.directory(this.workingDir.toFile());
        }
        Process sp = null;
        try {
            sp = processBuilder.start();
        }
        catch (IOException e) {
            this.abort("Failed to create a child process.", e);
        }
        return sp;
    }

    public IProcess newEclipseProcessWithLabelUpdater(ILaunch launch, Indexable<String> cmdLine, Process sp) throws CoreException {
        String cmdLineLabel = EclipseProcessLauncher.renderCommandLineLabel(cmdLine);
        String processLabel = this.renderProcessLabel();
        IProcess process = this.newEclipseProcess(launch, sp, processLabel);
        process.setAttribute(IProcess.ATTR_CMDLINE, cmdLineLabel);
        return process;
    }

    protected IProcess newEclipseProcess(ILaunch launch, Process sp, String label) throws CoreException {
        return new RuntimeProcessExtension(launch, sp, label, this.getProcessAttributes());
    }

    protected Map<String, String> getProcessAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.processType != null) {
            map.put(IProcess.ATTR_PROCESS_TYPE, this.processType);
        }
        return map;
    }

    protected String renderProcessLabel() {
        String timestampLabel = PROCESS_LABEL_DATE_FORMAT.format(new Date(System.currentTimeMillis()));
        String processFilePath = this.programFileLocation.toString();
        return MessageFormat.format("{0} ({1})", processFilePath, timestampLabel);
    }

    protected static String renderCommandLineLabel(Indexable<String> commandLine) {
        return StringUtil.collToString(commandLine, (String)"\n");
    }
}

