/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.utils.prefs;

import java.util.Optional;
import melnorme.lang.ide.core.utils.prefs.PreferenceHelper;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.MiscUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferencesLookupHelper
implements PreferenceHelper.IPreferencesAccess {
    public final String qualifier;
    protected final IScopeContext[] contexts;

    public PreferencesLookupHelper(String qualifier) {
        this(qualifier, null);
    }

    public PreferencesLookupHelper(String qualifier, Optional<IProject> project) {
        this.qualifier = qualifier;
        project = MiscUtil.toOptional(project);
        this.contexts = project.isPresent() ? (IScopeContext[])CoreUtil.array((Object[])new IScopeContext[]{new ProjectScope((IProject)project.get()), InstanceScope.INSTANCE, DefaultScope.INSTANCE}) : (IScopeContext[])CoreUtil.array((Object[])new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE});
    }

    protected static IPreferencesService preferences() {
        return Platform.getPreferencesService();
    }

    protected String assertKeyHasDefault(String key) {
        return (String)Assert.AssertNamespace.assertNotNull((Object)DefaultScope.INSTANCE.getNode(this.qualifier).get(key, null));
    }

    @Override
    public String getString(String key) {
        this.assertKeyHasDefault(key);
        return this.getString(key, "");
    }

    public String getString(String key, String defaultValue) {
        return PreferencesLookupHelper.preferences().getString(this.qualifier, key, defaultValue, this.contexts);
    }
}

