/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.utils.prefs;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Supplier;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.PreferencesOverride;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.core.utils.prefs.IGlobalPreference;
import melnorme.lang.ide.core.utils.prefs.IProjectPreference;
import melnorme.lang.ide.core.utils.prefs.PreferencesLookupHelper;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.fields.Field;
import melnorme.utilbox.fields.IFieldView;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public abstract class PreferenceHelper<T>
implements IGlobalPreference<T> {
    protected static final HashMap<String, PreferenceHelper<?>> instances = new HashMap();
    public final String key;
    public final String qualifier;
    protected T defaultValue;
    protected final IProjectPreference<Boolean> useProjectPreference;
    protected final Field<T> field = new Field();
    protected final IProjectPreference<T> projectPreference = new IProjectPreference<T>(){

        @Override
        public PreferenceHelper<T> getGlobalPreference() {
            return PreferenceHelper.this;
        }

        @Override
        public T getDefaultValue() {
            return PreferenceHelper.this.getDefaultValue();
        }

        @Override
        public Supplier<T> getEffectiveValueProperty(final Optional<IProject> project) {
            return new Supplier<T>(){

                @Override
                public T get() {
                    return this.getEffectiveValue(project);
                }
            };
        }

        @Override
        public T getStoredValue(Optional<IProject> project) {
            return PreferenceHelper.this.getProjectScopeValue(project);
        }

        @Override
        public void setValue(IProject project, T value) throws CommonException {
            this.doSetValue(project, value);
            PreferenceHelper.this.flush(project);
        }

        @Override
        public void doSetValue(IProject project, T newValue) {
            Assert.AssertNamespace.assertNotNull((Object)project);
            IEclipsePreferences projectPreferences = PreferenceHelper.this.getProjectNode(project);
            try {
                ResourceUtils.ProjectLocation projLocHandle = ResourceUtils.locationHandle(project);
                LangCore.settings().notifySettingChanged(this, projLocHandle, newValue);
            }
            catch (CommonException e) {
                LangCore.logError("Error changing preference.", e);
            }
            PreferenceHelper.this.setPrefValue(projectPreferences, newValue);
        }

        @Override
        public T getEffectiveValue(Optional<IProject> project) {
            Assert.AssertNamespace.assertNotNull(this.getEnableProjectSettingPref());
            if (project != null && this.getEnableProjectSettingPref().getStoredValue(project).booleanValue()) {
                return this.getStoredValue(project);
            }
            return this.getGlobalPreference().get();
        }

        @Override
        public IProjectPreference<Boolean> getEnableProjectSettingPref() {
            return PreferenceHelper.this.useProjectPreference;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkUniqueKey(String key, PreferenceHelper<?> preference) {
        HashMap<String, PreferenceHelper<?>> hashMap = instances;
        synchronized (hashMap) {
            Assert.AssertNamespace.assertTrue((!instances.containsKey(key) ? 1 : 0) != 0);
            instances.put(key, preference);
        }
    }

    public PreferenceHelper(String key, T defaultValue) {
        this("com.googlecode.goclipse.core", key, defaultValue);
    }

    public PreferenceHelper(String pluginId, String key, T defaultValue) {
        this(pluginId, key, defaultValue, true, null);
    }

    public PreferenceHelper(String pluginId, String key, T defaultValue, IProjectPreference<Boolean> useProjectPref) {
        this(pluginId, key, defaultValue, true, useProjectPref);
    }

    public PreferenceHelper(String key, T defaultValue, IProjectPreference<Boolean> useProjectPref) {
        this("com.googlecode.goclipse.core", key, defaultValue, true, useProjectPref);
    }

    public PreferenceHelper(String pluginId, String key, T defaultValue, boolean ensureUniqueKey, IProjectPreference<Boolean> useProjectPreference) {
        this.key = (String)Assert.AssertNamespace.assertNotNull((Object)PreferencesOverride.getKeyIdentifer(key, this));
        if (ensureUniqueKey) {
            PreferenceHelper.checkUniqueKey(key, this);
        }
        this.qualifier = pluginId;
        this.useProjectPreference = useProjectPreference;
        this.setPreferencesDefaultValue(defaultValue);
        this.updateFieldFromPrefStore();
        this.initializeListeners();
    }

    public final String getQualifier() {
        return this.qualifier;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public IFieldView<T> asField() {
        return this.field;
    }

    public void setPreferencesDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        this.setPrefValue(this.getDefaultNode(), defaultValue);
        this.updateFieldFromPrefStore();
    }

    protected void updateFieldFromPrefStore() {
        this.field.setFieldValue(this.getFromPrefStore());
    }

    protected IPreferencesAccess prefScopes() {
        return new PreferencesLookupHelper(this.getQualifier());
    }

    protected IPreferencesAccess prefScopes(Optional<IProject> project) {
        return new PreferencesLookupHelper(this.getQualifier(), project);
    }

    protected IEclipsePreferences getDefaultNode() {
        return DefaultScope.INSTANCE.getNode(this.getQualifier());
    }

    public final T getFromPrefStore() {
        return this.getPrefValue(this.prefScopes());
    }

    protected T getPrefValue(IPreferencesAccess prefsAccess) {
        return this.getPrefValue(prefsAccess.getString(this.key));
    }

    protected T getPrefValue(String savedValue) {
        return (T)Assert.AssertNamespace.assertNotNull(this.parseString(savedValue));
    }

    protected void setPrefValue(IEclipsePreferences preferences, T value) {
        if (value == null) {
            preferences.remove(this.key);
        } else {
            preferences.put(this.key, this.valueToString(value));
        }
    }

    protected abstract T parseString(String var1);

    protected abstract String valueToString(T var1);

    protected void initializeListeners() {
        InstanceScope.INSTANCE.getNode(this.qualifier).addPreferenceChangeListener(event -> this.handlePreferenceChange(event));
    }

    @Override
    public final void setInstanceScopeValue(T value) throws CommonException {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(this.getQualifier());
        this.setPrefValue(prefs, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            PreferenceHelper.throwCommonException(e);
        }
    }

    public static void throwCommonException(BackingStoreException e) throws CommonException {
        throw new CommonException(e.getMessage(), e.getCause());
    }

    protected void handlePreferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(this.key)) {
            this.updateFieldFromPrefStore();
        }
    }

    @Override
    public IProjectPreference<T> getProjectPreference() {
        return this.projectPreference;
    }

    protected final T getProjectScopeValue(Optional<IProject> project) {
        return this.getPrefValue(this.prefScopes(project));
    }

    protected void flush(IProject project) throws CommonException {
        try {
            this.getProjectNode(project).flush();
        }
        catch (BackingStoreException e) {
            PreferenceHelper.throwCommonException(e);
        }
    }

    protected IEclipsePreferences getProjectNode(IProject project) {
        return new ProjectScope(project).getNode(this.getQualifier());
    }

    public static interface IPreferencesAccess {
        public String getString(String var1);
    }
}

