/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Optional;
import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.tooling.LocationHandle;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.lang.tooling.common.ops.Operation;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.fntypes.RunnableX;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.ownership.IOwner;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ResourceUtils {
    public static Path epath(Location loc) {
        return new Path(loc.path.toString());
    }

    public static Path epath(java.nio.file.Path path) {
        return new Path(path.toString());
    }

    public static Location loc(IPath location) {
        return Location.create_fromValid((java.nio.file.Path)location.toFile().toPath());
    }

    public static URI toUri(IPath path) {
        if (path == null) {
            return null;
        }
        return path.toFile().toURI();
    }

    public static Location getResourceLocation(IResource resource) {
        IPath location = resource.getLocation();
        if (location == null) {
            return null;
        }
        return ResourceUtils.loc(location);
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static Location getWorkspaceLocation() {
        IPath location_ = ResourceUtils.getWorkspaceRoot().getLocation();
        return Location.fromAbsolutePath((java.nio.file.Path)location_.toFile().toPath());
    }

    public static Location getProjectLocation2(IProject project) throws CommonException {
        return ResourceUtils.getLocation((IResource)project);
    }

    public static Location getLocation(IResource resource) throws CommonException {
        IPath location = resource.getLocation();
        if (location == null) {
            throw new CommonException("Invalid resource location: " + resource.getLocationURI());
        }
        return Location.create((java.nio.file.Path)location.toFile().toPath());
    }

    public static ProjectLocation locationHandle(IProject project) throws CommonException {
        return new ProjectLocation(project);
    }

    public static IProject getProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    public static IProject getProjectAt(Location location) {
        IContainer[] containers;
        IContainer[] iContainerArray = containers = ResourceUtils.getWorkspaceRoot().findContainersForLocationURI(location.toUri());
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer container = iContainerArray[n2];
            if (container instanceof IProject) {
                return (IProject)container;
            }
            ++n2;
        }
        return null;
    }

    public static IProject getProjectAt(LocationHandle location) {
        if (location instanceof ProjectLocation) {
            ProjectLocation projectLocation = (ProjectLocation)location;
            return projectLocation.getProject();
        }
        return ResourceUtils.getProjectAt(location.getLocation());
    }

    public static IProject getProjectFromMemberLocation(Location fileLocation) {
        IFile[] files;
        IFile[] iFileArray = files = ResourceUtils.getWorkspaceRoot().findFilesForLocationURI(fileLocation.toUri());
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            IProject project = file.getProject();
            if (project.exists() && project.isOpen()) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    public static IProject getProjectFromMemberLocation(Optional<Location> location) {
        if (location.isPresent()) {
            return ResourceUtils.getProjectFromMemberLocation(location.get());
        }
        return null;
    }

    public static void runCoreOperation2(ISchedulingRule rule, IProgressMonitor pm, final Operation operation) throws CoreException, CommonException, OperationCancellation {
        Assert.AssertNamespace.assertNotNull((Object)rule);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    operation.execute(EclipseUtils.om(monitor));
                }
                catch (CommonException e) {
                    throw new CommonException_CEWrapper(e);
                }
                catch (OperationCancellation e) {
                    throw new CancellationException_CEWrapper(e);
                }
            }
        };
        try {
            ResourceUtils.getWorkspace().run(runnable, rule, 1, pm);
        }
        catch (CommonException_CEWrapper cew) {
            throw cew.wrapped;
        }
        catch (CancellationException_CEWrapper cew) {
            throw cew.wrapped;
        }
    }

    public static void runOperation(ISchedulingRule rule, IOperationMonitor om, Operation operation) throws CommonException, OperationCancellation {
        try {
            ResourceUtils.runCoreOperation2(rule, EclipseUtils.pm((ICancelMonitor)om), operation);
        }
        catch (CoreException e) {
            throw EclipseUtils.createCommonException(e);
        }
    }

    public static void runOperationUnderResource(IResource resource, IOperationMonitor om, Operation operation) throws CommonException, OperationCancellation {
        ResourceUtils.runOperation((ISchedulingRule)resource, om, operation);
        ResourceUtils.refresh(resource, om);
    }

    public static void runWorkspaceOperation(IProgressMonitor pm, Operation operation) throws OperationCancellation, CommonException {
        try {
            ResourceUtils.runCoreOperation2((ISchedulingRule)ResourceUtils.getWorkspaceRoot(), pm, operation);
        }
        catch (CoreException e) {
            throw EclipseUtils.createCommonException(e);
        }
    }

    public static void runProjectOperation(IOperationMonitor om, IProject project, Operation operation) throws OperationCancellation, CommonException {
        ResourceUtils.runOperation((ISchedulingRule)project, om, operation);
    }

    public static void runOperation(IRunnableContext context, final Operation op, boolean isCancellable) throws OperationCancellation, CommonException {
        try {
            context.run(true, isCancellable, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        op.execute(EclipseUtils.om(monitor));
                    }
                    catch (CommonException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCancellation | OperationCanceledException e) {
                        throw new InterruptedException();
                    }
                }
            });
        }
        catch (InterruptedException e) {
            throw new OperationCancellation();
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof InterruptedException) {
                throw new OperationCancellation();
            }
            if (targetException instanceof CommonException) {
                throw (CommonException)targetException;
            }
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            Assert.AssertNamespace.assertFail();
        }
    }

    public static void runOperationInWorkspace(IRunnableContext context, boolean isCancellable, Operation op) throws OperationCancellation, CommonException {
        ResourceUtils.runOperation(context, pm -> ResourceUtils.runOperation((ISchedulingRule)ResourceUtils.getWorkspaceRoot(), pm, op), isCancellable);
    }

    public static void refresh(IResource resource, IOperationMonitor om) throws CommonException {
        try {
            resource.refreshLocal(2, EclipseUtils.pm((ICancelMonitor)om));
        }
        catch (CoreException e) {
            throw EclipseUtils.createCommonException(e);
        }
    }

    public static void writeToFile(IFile file, InputStream is, IProgressMonitor pm) throws CoreException {
        if (file.exists()) {
            file.setContents(is, false, false, pm);
        } else {
            file.create(is, false, null);
        }
    }

    public static void writeStringToFile(IFile file, String contents, IProgressMonitor pm) throws CoreException {
        ResourceUtils.writeStringToFile(file, contents, StringUtil.UTF8, pm);
    }

    public static void writeStringToFile(IFile file, String contents, Charset charset, IProgressMonitor pm) throws CoreException {
        ResourceUtils.writeToFile(file, new ByteArrayInputStream(contents.getBytes(charset)), pm);
    }

    public static void createFolder(IFolder folder, boolean force, IProgressMonitor monitor) throws CoreException {
        ResourceUtils.createFolder(folder, force, true, monitor);
    }

    public static void createFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (folder.exists()) {
            return;
        }
        IContainer parent = folder.getParent();
        if (parent instanceof IFolder) {
            ResourceUtils.createFolder((IFolder)parent, force, local, monitor);
        }
        folder.create(force, local, monitor);
    }

    public static String printDelta(IResourceDelta delta) {
        StringBuilder sb = new StringBuilder();
        ResourceUtils.doPrintDelta(delta, "  ", sb);
        return sb.toString();
    }

    protected static void doPrintDelta(IResourceDelta delta, String indent, StringBuilder sb) {
        sb.append(indent);
        sb.append(delta);
        sb.append(" " + ResourceUtils.deltaKindToString(delta) + "\n");
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta childDelta = iResourceDeltaArray[n2];
            ResourceUtils.doPrintDelta(childDelta, String.valueOf(indent) + "  ", sb);
            ++n2;
        }
    }

    protected static String deltaKindToString(IResourceDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                return "+";
            }
            case 2: {
                return "-";
            }
            case 4: {
                return "*";
            }
            case 8: {
                return "%+%";
            }
            case 16: {
                return "%-%";
            }
        }
        throw Assert.AssertNamespace.assertFail();
    }

    public static IProject createAndOpenProject(String name, boolean overwrite) throws CoreException {
        return ResourceUtils.createAndOpenProject(name, overwrite, null);
    }

    public static IProject createAndOpenProject(String name, boolean overwrite, IProgressMonitor pm) throws CoreException {
        return ResourceUtils.createAndOpenProject(name, null, overwrite, pm);
    }

    public static IProject createAndOpenProject(String name, IPath location, boolean overwrite, IProgressMonitor pm) throws CoreException {
        IPath workspaceLocation;
        IProject project = EclipseUtils.getWorkspaceRoot().getProject(name);
        if (overwrite && project.exists()) {
            project.delete(true, pm);
        }
        IProjectDescription projectDesc = project.getWorkspace().newProjectDescription(project.getName());
        if (location != null && !location.equals((Object)(workspaceLocation = project.getWorkspace().getRoot().getLocation()).append(project.getName()))) {
            projectDesc.setLocation(location);
        }
        project.create(projectDesc, pm);
        project.open(pm);
        return project;
    }

    public static void tryDeleteProject(String projectName) throws CoreException {
        IProject project = EclipseUtils.getWorkspaceRoot().getProject(projectName);
        ResourceUtils.tryDeleteProject(project);
    }

    public static void tryDeleteProject(IProject project) throws CoreException {
        block2: {
            try {
                project.delete(true, null);
            }
            catch (CoreException ce) {
                if (!project.exists()) break block2;
                throw ce;
            }
        }
    }

    public static ITextFileBuffer getTextFileBuffer(ITextFileBufferManager fbm, Location fileLoc) {
        return ResourceUtils.getTextFileBuffer(fbm, fileLoc.path);
    }

    public static ITextFileBuffer getTextFileBuffer(ITextFileBufferManager fbm, java.nio.file.Path filePath) {
        ITextFileBuffer fileBuffer = fbm.getTextFileBuffer((IPath)ResourceUtils.epath(filePath), LocationKind.NORMALIZE);
        if (fileBuffer != null) {
            return fileBuffer;
        }
        fileBuffer = fbm.getFileStoreTextFileBuffer(FileBuffers.getFileStoreAtLocation((IPath)ResourceUtils.epath(filePath)));
        if (fileBuffer != null) {
            return fileBuffer;
        }
        fileBuffer = fbm.getTextFileBuffer((IPath)ResourceUtils.epath(filePath), LocationKind.LOCATION);
        if (fileBuffer != null) {
            return fileBuffer;
        }
        return null;
    }

    public static void connectResourceListener(final IResourceChangeListener listener, final RunnableX<CoreException> initialUpdate, ISchedulingRule opRule, IOwner owner) {
        try {
            ResourceUtils.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ResourceUtils.getWorkspace().addResourceChangeListener(listener, 1);
                    initialUpdate.run();
                }
            }, opRule, 1, null);
        }
        catch (CoreException ce) {
            EclipseCore.logStatus(ce);
            ResourceUtils.getWorkspace().addResourceChangeListener(listener, 1);
        }
        owner.bind(() -> ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener));
    }

    protected static class CancellationException_CEWrapper
    extends CoreException {
        public final OperationCancellation wrapped;

        public CancellationException_CEWrapper(OperationCancellation wrapped) {
            super((IStatus)EclipseCore.createErrorStatus("Error: ", wrapped));
            this.wrapped = (OperationCancellation)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)wrapped)));
        }
    }

    protected static class CommonException_CEWrapper
    extends CoreException {
        public final CommonException wrapped;

        public CommonException_CEWrapper(CommonException wrapped) {
            super((IStatus)EclipseCore.createErrorStatus("Error: ", wrapped));
            this.wrapped = (CommonException)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)wrapped)));
        }
    }

    public static interface CoreOperation
    extends Operation {
        default public void execute(IOperationMonitor om) throws CommonException, OperationCancellation {
            try {
                this.execute_do(EclipseUtils.pm((ICancelMonitor)om));
            }
            catch (CoreException e) {
                throw EclipseUtils.createCommonException(e);
            }
        }

        public void execute_do(IProgressMonitor var1) throws CoreException, CommonException, OperationCancellation;
    }

    public static class ProjectLocation
    extends LocationHandle {
        protected final IProject project;

        public ProjectLocation(IProject project) throws CommonException {
            super(ResourceUtils.getProjectLocation2(project));
            this.project = (IProject)Assert.AssertNamespace.assertNotNull((Object)project);
        }

        public IProject getProject() {
            return this.project;
        }
    }
}

