/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.utils;

import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.LangCoreMessages;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.utils.validators.AbstractValidator;
import melnorme.utilbox.status.StatusException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ProjectValidator
extends AbstractValidator {
    protected final String natureId;

    public ProjectValidator() {
        this(null);
    }

    public ProjectValidator(String natureId) {
        this.natureId = natureId;
    }

    public IProject getProjectHandle(String projectName) throws StatusException {
        if (projectName == null || projectName.isEmpty()) {
            throw this.error(this.msg_ProjectNotSpecified());
        }
        EclipseUtils.validate(() -> ResourceUtils.getWorkspace().validateName(projectName, 4));
        return ResourceUtils.getWorkspaceRoot().getProject(projectName);
    }

    public IProject getProject(String projectName) throws StatusException {
        IProject project = this.getProjectHandle(projectName);
        return this.validateProject(project);
    }

    public IProject validateProject(IProject project) throws StatusException {
        this.checkProjectNotNull(project);
        this.checkProjectExists(project);
        try {
            if (this.natureId != null && !project.hasNature(this.natureId)) {
                throw this.error(this.msg_NotAValidLangProject());
            }
            return project;
        }
        catch (CoreException ce) {
            EclipseCore.logStatus(ce);
            throw this.error(ce.getMessage());
        }
    }

    public void checkProjectNotNull(IProject project) throws StatusException {
        if (project == null) {
            throw this.error(this.msg_ProjectNotSpecified());
        }
    }

    public void checkProjectExists(IProject project) throws StatusException {
        if (!project.exists()) {
            throw this.error(this.msg_ProjectDoesNotExist());
        }
    }

    public String msg_ProjectNotSpecified() {
        return LangCoreMessages.error_selectProject;
    }

    public String msg_ProjectDoesNotExist() {
        return LangCoreMessages.error_projectDoesNotExist;
    }

    public String msg_NotAValidLangProject() {
        return LangCoreMessages.error_notAValidProject;
    }
}

