/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.utils;

import java.util.ArrayList;
import java.util.function.Supplier;
import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.lang.tooling.common.ops.Operation;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.ArrayUtil;
import melnorme.utilbox.status.IStatusMessage;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusException;
import melnorme.utilbox.status.StatusLevel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class EclipseUtils {
    public static final String MSG__ERROR_TRYING_TO_START_PLUGIN = "Error trying to start plugin: ";

    public static CommonException createCommonException(CoreException ce) {
        return new CommonException(ce.getMessage(), ce.getCause());
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void startOtherPlugin(String pluginId) {
        try {
            Bundle debugPlugin = Platform.getBundle((String)pluginId);
            if (debugPlugin == null) {
                throw new BundleException("Plugin not found");
            }
            if (debugPlugin.getState() != 8) {
                debugPlugin.start(1);
            }
        }
        catch (BundleException e) {
            LangCore.logError(MSG__ERROR_TRYING_TO_START_PLUGIN + pluginId, e);
        }
    }

    public static IProject[] getOpenedProjects(String natureId) throws CoreException {
        IProject[] projects;
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = EclipseUtils.getWorkspaceRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.exists() && project.isOpen() && (natureId == null || project.hasNature(natureId))) {
                result.add(project);
            }
            ++n2;
        }
        return (IProject[])ArrayUtil.createFrom(result, IProject.class);
    }

    public static void addNature(IProject project, String natureID) throws CoreException {
        IProjectDescription description = project.getDescription();
        Object[] natures = description.getNatureIds();
        if (ArrayUtil.contains((Object[])natures, (Object)natureID)) {
            return;
        }
        String[] newNatures = (String[])ArrayUtil.append((Object[])natures, (Object)natureID);
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    public static void removeNature(IProject project, String natureID) throws CoreException {
        IProjectDescription description = project.getDescription();
        Object[] natures = description.getNatureIds();
        String[] newNatures = (String[])ArrayUtil.remove((Object[])natures, (Object)natureID);
        if (newNatures != natures) {
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
    }

    public static <T> T getAdapter(Object adaptable, Class<T> adapterType) {
        return (T)Platform.getAdapterManager().getAdapter(adaptable, adapterType);
    }

    public static int toEclipseSeverity(IStatusMessage se) {
        return EclipseUtils.toEclipseSeverity(se.getSeverity());
    }

    public static int toEclipseSeverity(Severity severity) {
        return EclipseUtils.toEclipseSeverity(severity.toStatusLevel());
    }

    public static int toEclipseSeverity(StatusLevel statusLevel) {
        switch (statusLevel) {
            case OK: {
                return 0;
            }
            case INFO: {
                return 1;
            }
            case WARNING: {
                return 2;
            }
            case ERROR: {
                return 4;
            }
        }
        throw Assert.AssertNamespace.assertUnreachable();
    }

    public static StatusLevel toStatusLevel(IStatus status) {
        switch (status.getSeverity()) {
            case 8: {
                return null;
            }
            case 0: {
                return StatusLevel.OK;
            }
            case 1: {
                return StatusLevel.INFO;
            }
            case 2: {
                return StatusLevel.WARNING;
            }
            case 4: {
                return StatusLevel.ERROR;
            }
        }
        throw Assert.AssertNamespace.assertUnreachable();
    }

    public static void validate(Supplier<IStatus> statusGetter) throws StatusException {
        IStatus status = statusGetter.get();
        StatusException se = EclipseUtils.statusToStatusException3(status);
        if (se != null) {
            throw se;
        }
    }

    public static StatusException statusToStatusException3(IStatus status) throws StatusException {
        if (status.isOK() || status.getSeverity() == 8) {
            return null;
        }
        Severity severity = EclipseUtils.toStatusLevel(status).toSeverity();
        return new StatusException(severity, status.getMessage(), status.getException());
    }

    public static void execute_asCore(IOperationMonitor om, Operation commonOperation) throws OperationCancellation, CoreException {
        try {
            commonOperation.execute(om);
        }
        catch (CommonException ce) {
            throw EclipseCore.createCoreException(ce);
        }
    }

    public static ICancelMonitor cm(IProgressMonitor pm) {
        return new EclipseCancelMonitor(pm);
    }

    public static IOperationMonitor om(final IProgressMonitor pm) {
        return new IOperationMonitor.BasicOperationMonitor(EclipseUtils.cm(pm), null, true){

            public void setTaskName(String taskName) {
                pm.setTaskName(taskName);
            }
        };
    }

    public static IProgressMonitor pm(final ICancelMonitor cm) {
        if (cm instanceof EclipseCancelMonitor) {
            EclipseCancelMonitor ecm = (EclipseCancelMonitor)cm;
            return ecm.pm;
        }
        return new NullProgressMonitor(){

            public boolean isCanceled() {
                return cm.isCanceled();
            }
        };
    }

    public static void run(CoreRunnable coreRunnable) throws CommonException {
        try {
            coreRunnable.execute();
        }
        catch (CoreException e) {
            throw EclipseUtils.createCommonException(e);
        }
    }

    public static <R> R call(CoreCallable<R> coreCallable) throws CommonException {
        try {
            return coreCallable.execute();
        }
        catch (CoreException e) {
            throw EclipseUtils.createCommonException(e);
        }
    }

    public static <R> R callCore(CoreCallable<R> coreCallable) throws CoreException {
        try {
            return coreCallable.execute();
        }
        catch (CommonException e) {
            throw EclipseCore.createCoreException(e);
        }
    }

    public static interface CoreCallable<R> {
        public R execute() throws CoreException, CommonException;
    }

    public static interface CoreRunnable {
        public void execute() throws CoreException, CommonException;
    }

    public static class EclipseCancelMonitor
    implements ICancelMonitor {
        protected final IProgressMonitor pm;

        public EclipseCancelMonitor(IProgressMonitor pm) {
            this.pm = (IProgressMonitor)Assert.AssertNamespace.assertNotNull((Object)pm);
        }

        public boolean isCanceled() {
            return this.pm.isCanceled();
        }
    }
}

