/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.utils;

import java.util.concurrent.SynchronousQueue;
import melnorme.lang.ide.core.LangCore;
import melnorme.utilbox.concurrency.ExecutorTaskAgent;
import melnorme.utilbox.concurrency.ICommonExecutor;
import melnorme.utilbox.concurrency.ThreadPoolExecutorExt;

public class CoreExecutors {
    public static ExecutorTaskAgent newExecutorTaskAgent(Class<?> ownerKlass) {
        return CoreExecutors.newExecutorTaskAgent(ownerKlass.getSimpleName());
    }

    public static ExecutorTaskAgent newExecutorTaskAgent(String name) {
        return new ExecutorTaskAgent(name, (ThreadPoolExecutorExt.UncaughtExceptionHandler)new CoreUncaughtExceptionHandler(name));
    }

    public static ICommonExecutor newCachedThreadPool(Class<?> ownerKlass) {
        return CoreExecutors.newCachedThreadPool(ownerKlass, 0);
    }

    public static ICommonExecutor newCachedThreadPool(Class<?> ownerKlass, int corePoolSize) {
        String name = ownerKlass.getSimpleName();
        return CoreExecutors.newCachedThreadPool(name, corePoolSize);
    }

    public static ICommonExecutor newCachedThreadPool(String name, int corePoolSize) {
        return new ThreadPoolExecutorExt(corePoolSize, Integer.MAX_VALUE, new SynchronousQueue(), name, (ThreadPoolExecutorExt.UncaughtExceptionHandler)new CoreUncaughtExceptionHandler(name));
    }

    public static class CoreUncaughtExceptionHandler
    implements ThreadPoolExecutorExt.UncaughtExceptionHandler {
        protected final String name;

        public CoreUncaughtExceptionHandler(String name) {
            this.name = name;
        }

        public void accept(Throwable throwable) {
            LangCore.logError("Unhandled exception in Executor " + this.name, throwable);
        }
    }
}

