/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.text.format;

import melnorme.lang.ide.core.text.BlockHeuristicsScannner;
import melnorme.lang.ide.core.text.TextSourceUtils;
import melnorme.lang.ide.core.text.format.AbstractAutoEditStrategy;
import melnorme.lang.ide.core.text.format.ILangAutoEditsPreferencesAccess;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;

public class LangAutoEditStrategy
extends AbstractAutoEditStrategy {
    protected static final BlockHeuristicsScannner.BlockTokenRule[] BLOCK_RULES_Braces = (BlockHeuristicsScannner.BlockTokenRule[])CoreUtil.array((Object[])new BlockHeuristicsScannner.BlockTokenRule[]{new BlockHeuristicsScannner.BlockTokenRule('{', '}')});
    protected static final BlockHeuristicsScannner.BlockTokenRule[] BLOCK_RULES_BracesAndParenthesis = (BlockHeuristicsScannner.BlockTokenRule[])CoreUtil.array((Object[])new BlockHeuristicsScannner.BlockTokenRule[]{new BlockHeuristicsScannner.BlockTokenRule('{', '}'), new BlockHeuristicsScannner.BlockTokenRule('(', ')')});
    protected final ILangAutoEditsPreferencesAccess preferences;
    protected final String partitioning;
    protected final String contentType;
    protected boolean parenthesesAsBlocks;
    protected String indentUnit;

    protected LangAutoEditStrategy(ITextViewer viewer, ILangAutoEditsPreferencesAccess preferences) {
        this(viewer, "__dftl_partitioning", "__dftl_partition_content_type", preferences);
    }

    public LangAutoEditStrategy(ITextViewer viewer, String partitioning, String contentType, ILangAutoEditsPreferencesAccess preferences) {
        super(viewer);
        this.preferences = preferences;
        this.partitioning = partitioning;
        this.contentType = contentType;
    }

    @Override
    protected void doCustomizeDocumentCommand(IDocument doc, DocumentCommand cmd) throws BadLocationException {
        this.parenthesesAsBlocks = this.preferences.parenthesesAsBlocks();
        this.indentUnit = this.preferences.getIndentUnit();
        boolean isSmartIndent = this.preferences.isSmartIndent();
        if (isSmartIndent && this.isSimpleNewLineKeyPress(cmd)) {
            this.smartIndentAfterNewLine(doc, cmd);
        } else {
            if (this.smartDeIndentAfterDeletion(doc, cmd)) {
                return;
            }
            if (isSmartIndent && LangAutoEditStrategy.isSimpleKeyPressCommand(cmd)) {
                this.smartIndentOnKeypress(doc, cmd);
            }
        }
    }

    protected BlockHeuristicsScannner createBlockHeuristicsScanner(IDocument doc) {
        return new BlockHeuristicsScannner(doc, this.partitioning, this.contentType, this.getBlockRules());
    }

    protected BlockHeuristicsScannner.BlockTokenRule[] getBlockRules() {
        if (this.parenthesesAsBlocks) {
            return BLOCK_RULES_BracesAndParenthesis;
        }
        return BLOCK_RULES_Braces;
    }

    protected void smartIndentAfterNewLine(IDocument doc, DocumentCommand cmd) throws BadLocationException {
        if (cmd.length > 0 || cmd.text == null) {
            return;
        }
        IRegion lineRegion = doc.getLineInformationOfOffset(cmd.offset);
        int lineEnd = LangAutoEditStrategy.getRegionEnd(lineRegion);
        int postWsEndPos = TextSourceUtils.findEndOfIndent(this.docContents, cmd.offset);
        boolean hasPendingTextAfterEdit = postWsEndPos != lineEnd;
        BlockHeuristicsScannner bhscanner = this.createBlockHeuristicsScanner(doc);
        int offsetForBalanceCalculation = this.findOffsetForBalanceCalculation(doc, bhscanner, cmd.offset);
        int lineForBalanceCalculation = doc.getLineOfOffset(cmd.offset);
        LineIndentResult nli = this.determineIndent(doc, bhscanner, lineForBalanceCalculation, offsetForBalanceCalculation);
        cmd.text = String.valueOf(cmd.text) + nli.nextLineIndent;
        BlockHeuristicsScannner.BlockBalanceResult blockInfo = nli.blockInfo;
        if (blockInfo.unbalancedOpens > 0) {
            if (this.preferences.closeBraces() && !hasPendingTextAfterEdit && bhscanner.shouldCloseBlock(blockInfo.rightmostUnbalancedBlockOpenOffset)) {
                cmd.caretOffset = cmd.offset + cmd.text.length();
                cmd.shiftsCaret = false;
                String delimiter = TextUtilities.getDefaultLineDelimiter((IDocument)doc);
                char openChar = doc.getChar(blockInfo.rightmostUnbalancedBlockOpenOffset);
                char closeChar = bhscanner.getClosingPeer(openChar);
                cmd.text = String.valueOf(cmd.text) + delimiter + this.addIndent(nli.editLineIndent, blockInfo.unbalancedOpens - 1) + closeChar;
            }
            return;
        }
    }

    protected int findOffsetForBalanceCalculation(IDocument doc, BlockHeuristicsScannner bhscanner, int offset) {
        while (offset < doc.getLength()) {
            char ch;
            try {
                ch = doc.getChar(offset);
            }
            catch (BadLocationException e) {
                break;
            }
            if (!bhscanner.isClosingBrace(ch)) break;
            ++offset;
        }
        return offset;
    }

    protected final LineIndentResult determineIndent(IDocument doc, BlockHeuristicsScannner bhscanner, int line) throws BadLocationException {
        IRegion lineRegion = doc.getLineInformation(line);
        return this.determineIndent(doc, bhscanner, line, LangAutoEditStrategy.getRegionEnd(lineRegion));
    }

    protected LineIndentResult determineIndent(IDocument doc, BlockHeuristicsScannner bhscanner, int line, int editOffset) throws BadLocationException {
        IRegion lineRegion = doc.getLineInformation(line);
        int lineStart = lineRegion.getOffset();
        Assert.AssertNamespace.assertTrue((lineStart <= editOffset && editOffset <= LangAutoEditStrategy.getRegionEnd(lineRegion) ? 1 : 0) != 0);
        ITypedRegion partition = bhscanner.getPartition(lineStart);
        if (this.partitionIsIgnoredForLineIndentString(editOffset, partition)) {
            if (line == 0) {
                return new LineIndentResult("", "", new BlockHeuristicsScannner.BlockBalanceResult());
            }
            return this.determineIndent(doc, bhscanner, line - 1);
        }
        BlockHeuristicsScannner.BlockBalanceResult blockInfo = bhscanner.calculateBlockBalances(lineStart, editOffset);
        if (blockInfo.unbalancedOpens == 0 && blockInfo.unbalancedCloses > 0) {
            int blockStartOffset = bhscanner.findBlockStart(blockInfo.rightmostUnbalancedBlockCloseOffset);
            Assert.AssertNamespace.assertTrue((doc.getLineOfOffset(blockStartOffset) <= doc.getLineOfOffset(lineStart) ? 1 : 0) != 0);
            String startLineIndent = this.getLineIndentForOffset(blockStartOffset);
            int lineOffset = TextSourceUtils.findLineStartForOffset(this.docContents, blockStartOffset);
            BlockHeuristicsScannner.BlockBalanceResult blockStartInfo = bhscanner.calculateBlockBalances(lineOffset, blockStartOffset);
            String newLineIndent = this.addIndent(startLineIndent, blockStartInfo.unbalancedOpens);
            return new LineIndentResult(null, newLineIndent, blockInfo);
        }
        String lineIndent = this.getLineIndentForLineStart(lineStart, editOffset);
        if (blockInfo.unbalancedOpens == 0 && blockInfo.unbalancedCloses == 0) {
            return new LineIndentResult(null, lineIndent, blockInfo);
        }
        if (blockInfo.unbalancedOpens > 0) {
            String newLineIndent = this.addIndent(lineIndent, blockInfo.unbalancedOpens);
            return new LineIndentResult(lineIndent, newLineIndent, blockInfo);
        }
        throw Assert.AssertNamespace.assertUnreachable();
    }

    protected boolean partitionIsIgnoredForLineIndentString(int editOffset, ITypedRegion partition) {
        return this.partitionTypeIsIgnoredForLineIndentString(partition) && editOffset <= LangAutoEditStrategy.getRegionEnd((IRegion)partition);
    }

    protected boolean partitionTypeIsIgnoredForLineIndentString(ITypedRegion partition) {
        return !partition.getType().equals("__dftl_partition_content_type");
    }

    protected String addIndent(String indentStr, int indentDelta) {
        return String.valueOf(indentStr) + TextSourceUtils.stringNTimes(this.indentUnit, indentDelta);
    }

    protected boolean smartDeIndentAfterDeletion(IDocument doc, DocumentCommand cmd) throws BadLocationException {
        if (!this.preferences.isSmartDeIndent()) {
            return false;
        }
        if (!cmd.text.isEmpty()) {
            return false;
        }
        IRegion lineRegion = doc.getLineInformationOfOffset(cmd.offset);
        int lineEnd = LangAutoEditStrategy.getRegionEnd(lineRegion);
        int line = doc.getLineOfOffset(cmd.offset);
        if (cmd.offset == lineEnd && LangAutoEditStrategy.lengthMatchesLineDelimiter(cmd.length, doc.getLineDelimiter(line))) {
            if (this.keyWasBackspace()) {
                return false;
            }
            int indentLine = line + 1;
            if (indentLine < doc.getNumberOfLines()) {
                Assert.AssertNamespace.assertTrue((doc.getLineInformation(indentLine).getOffset() == cmd.offset + cmd.length ? 1 : 0) != 0);
                IRegion indentLineRegion = doc.getLineInformation(indentLine);
                int indentEnd = this.findEndOfIndent(indentLineRegion.getOffset());
                String deletableIndentStr = this.calculateDeletableIndent(doc, indentLine, indentEnd);
                if (LangAutoEditStrategy.equalsDocumentString(deletableIndentStr, doc, indentLineRegion)) {
                    cmd.length += deletableIndentStr.length();
                    return true;
                }
            }
            return false;
        }
        if (cmd.length == 1 && this.isIndentWhiteSpace(doc.getChar(cmd.offset)) && line > 0) {
            int acceptedIndentEnd;
            String deletableIndentStr;
            if (this.keyWasDelete()) {
                return false;
            }
            IRegion indentLineRegion = lineRegion;
            int indentLine = line;
            int indentEnd = this.findEndOfIndent(indentLineRegion.getOffset());
            if (cmd.offset < indentEnd && LangAutoEditStrategy.equalsDocumentString(deletableIndentStr = this.calculateDeletableIndent(doc, indentLine, indentEnd), doc, indentLineRegion) && cmd.offset == (acceptedIndentEnd = indentLineRegion.getOffset() + deletableIndentStr.length()) - 1) {
                int lineDelimLen = doc.getLineDelimiter(line - 1).length();
                cmd.offset = indentLineRegion.getOffset() - lineDelimLen;
                cmd.length = lineDelimLen + deletableIndentStr.length();
                return true;
            }
            return false;
        }
        return false;
    }

    protected static boolean lengthMatchesLineDelimiter(int length, String lineDelimiter) {
        return lineDelimiter != null && length == lineDelimiter.length();
    }

    protected boolean isIndentWhiteSpace(char ch) throws BadLocationException {
        return ch == ' ' || ch == '\t';
    }

    protected String calculateDeletableIndent(IDocument doc, int indentedLine, int indentEnd) throws BadLocationException {
        IRegion indentedLineRegion = doc.getLineInformation(indentedLine);
        String expectedIndentStr = this.determineExpectedIndent(doc, indentedLine - 1);
        int indentLength = indentEnd - indentedLineRegion.getOffset();
        if (indentLength < expectedIndentStr.length()) {
            expectedIndentStr = expectedIndentStr.substring(0, indentLength);
        }
        return expectedIndentStr;
    }

    protected String determineExpectedIndent(IDocument doc, int line) throws BadLocationException {
        BlockHeuristicsScannner bhscanner = this.createBlockHeuristicsScanner(doc);
        LineIndentResult nli = this.determineIndent(doc, bhscanner, line);
        String expectedIndentStr = nli.nextLineIndent;
        return expectedIndentStr;
    }

    protected void smartIndentOnKeypress(IDocument doc, DocumentCommand cmd) {
        Assert.AssertNamespace.assertTrue((cmd.text.length() == 1 ? 1 : 0) != 0);
        int offset = cmd.offset;
        int lineStart = TextSourceUtils.findLineStartForOffset(this.docContents, offset);
        String beforeCursor = this.docContents.substring(lineStart, offset);
        if (!beforeCursor.trim().isEmpty()) {
            return;
        }
        if (!this.isCloseSymbol(cmd.text)) {
            return;
        }
        char closeBrace = cmd.text.charAt(0);
        BlockHeuristicsScannner bhScanner = this.createBlockHeuristicsScanner(doc);
        int blockStartOffset = bhScanner.findBlockStart(offset, closeBrace);
        cmd.offset = lineStart;
        cmd.length = beforeCursor.length();
        String startLineIndent = this.getLineIndentForOffset(blockStartOffset);
        cmd.text = String.valueOf(startLineIndent) + closeBrace;
    }

    protected boolean isCloseSymbol(String string) {
        BlockHeuristicsScannner.BlockTokenRule[] blockTokenRuleArray = this.getBlockRules();
        int n = blockTokenRuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            BlockHeuristicsScannner.BlockTokenRule blockTokenRule = blockTokenRuleArray[n2];
            if (string.charAt(0) == blockTokenRule.close) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static class LineIndentResult {
        String editLineIndent;
        String nextLineIndent;
        BlockHeuristicsScannner.BlockBalanceResult blockInfo;

        public LineIndentResult(String editLineIndent, String nextLineIndent, BlockHeuristicsScannner.BlockBalanceResult blockInfo) {
            this.editLineIndent = editLineIndent;
            this.nextLineIndent = nextLineIndent;
            this.blockInfo = blockInfo;
        }
    }
}

