/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.text.format;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.text.TextSourceUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Event;

public abstract class AbstractAutoEditStrategy
implements IAutoEditStrategy {
    protected Event lastKeyEvent = new Event();
    protected String docContents;

    public AbstractAutoEditStrategy(ITextViewer viewer) {
        if (viewer instanceof ITextViewerExtension) {
            VerifyKeyRecorder verifyKeyRecorder = new VerifyKeyRecorder();
            ((ITextViewerExtension)viewer).appendVerifyKeyListener((VerifyKeyListener)verifyKeyRecorder);
        }
    }

    protected boolean keyWasBackspace() {
        return this.lastKeyEvent.character == '\b';
    }

    protected boolean keyWasDelete() {
        return this.lastKeyEvent.character == '\u007f';
    }

    protected boolean keyWasEnter() {
        return this.lastKeyEvent.character == '\r';
    }

    public void customizeDocumentCommand(IDocument doc, DocumentCommand cmd) {
        if (!cmd.doit) {
            return;
        }
        this.docContents = doc.get();
        try {
            this.doCustomizeDocumentCommand(doc, cmd);
        }
        catch (BadLocationException e) {
            LangCore.logError("BadLocationException in " + this.getClass().getSimpleName() + ".", e);
        }
    }

    protected abstract void doCustomizeDocumentCommand(IDocument var1, DocumentCommand var2) throws BadLocationException;

    public boolean isSimpleNewLineKeyPress(DocumentCommand cmd) {
        return this.keyWasEnter();
    }

    public static boolean isSimpleKeyPressCommand(DocumentCommand cmd) {
        return cmd.length == 0 && cmd.text.length() == 1;
    }

    public String getLineIndentForOffset(int offset) {
        return TextSourceUtils.getLineIndentForOffset(this.docContents, offset);
    }

    public String getLineIndentForLineStart(int lineStart) {
        return TextSourceUtils.getLineIndentForLineStart(this.docContents, lineStart);
    }

    public String getLineIndentForLineStart(int lineStart, int end) {
        return TextSourceUtils.getLineIndentForLineStart(this.docContents, lineStart, end);
    }

    public int findEndOfIndent(int offset) {
        return TextSourceUtils.findEndOfIndent(this.docContents, offset);
    }

    public static int getRegionEnd(IRegion region) {
        return region.getOffset() + region.getLength();
    }

    protected static boolean equalsDocumentString(String expectedIndentStr, IDocument doc, IRegion lineRegion) throws BadLocationException {
        int length = Math.min(lineRegion.getLength(), expectedIndentStr.length());
        String lineIndent = doc.get(lineRegion.getOffset(), length);
        return expectedIndentStr.equals(lineIndent);
    }

    public final class VerifyKeyRecorder
    implements VerifyKeyListener {
        public void verifyKey(VerifyEvent event) {
            AbstractAutoEditStrategy.this.lastKeyEvent.character = event.character;
            AbstractAutoEditStrategy.this.lastKeyEvent.keyCode = event.keyCode;
            AbstractAutoEditStrategy.this.lastKeyEvent.stateMask = event.stateMask;
        }
    }
}

