/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.text;

import java.util.Arrays;
import melnorme.lang.utils.parse.StringCharSource;
import melnorme.utilbox.core.Assert;
import org.eclipse.jface.text.IRegion;

public class TextSourceUtils {
    public static char getBracePair(char braceChar) {
        switch (braceChar) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
        }
        return braceChar;
    }

    public static boolean isPrefix(String prefix, String string, boolean ignoreCase) {
        if (prefix.length() > string.length()) {
            return false;
        }
        String subString = string.substring(0, prefix.length());
        return ignoreCase ? subString.equalsIgnoreCase(prefix) : subString.equals(prefix);
    }

    public static String getLineIndentForOffset(String source, int offset) {
        int lineStart = TextSourceUtils.findLineStartForOffset(source, offset);
        return TextSourceUtils.getLineIndentForLineStart(source, lineStart);
    }

    public static String getLineIndentForLine(String source, IRegion line) {
        return TextSourceUtils.getLineIndentForLineStart(source, line.getOffset());
    }

    public static String getLineIndentForLineStart(String source, int lineStart) {
        return TextSourceUtils.getLineIndentForLineStart(source, lineStart, source.length());
    }

    public static String getLineIndentForLineStart(String source, int lineStart, int endLimit) {
        int indentEnd = TextSourceUtils.findEndOfIndent(source, lineStart, endLimit);
        return source.substring(lineStart, indentEnd);
    }

    public static int findEndOfIndent(String source, int offset) {
        return TextSourceUtils.findEndOfIndent(source, offset, source.length());
    }

    public static int findEndOfIndent(String source, int offset, int endLimit) {
        Assert.AssertNamespace.assertTrue((endLimit <= source.length() ? 1 : 0) != 0);
        Assert.AssertNamespace.assertTrue((offset <= endLimit ? 1 : 0) != 0);
        StringCharSource parseSource = new StringCharSource(source);
        parseSource.consume(offset);
        while (offset < endLimit) {
            if (!parseSource.tryConsume(' ') && !parseSource.tryConsume('\t')) break;
            ++offset;
        }
        return parseSource.getReadPosition();
    }

    public static int findLineStartForOffset(String source, int offset) {
        Assert.AssertNamespace.assertTrue((offset <= source.length() ? 1 : 0) != 0);
        StringCharSource parseSource = new StringCharSource(source);
        while (offset > 0) {
            int previousChar = parseSource.lookahead(offset - 1);
            if (previousChar == 10 || previousChar == 13) break;
            --offset;
        }
        return offset;
    }

    public static String getLineSegmentBeforeOffset(String source, int offset) {
        int lineStart = TextSourceUtils.findLineStartForOffset(source, offset);
        return source.substring(lineStart, offset);
    }

    public static String getNSpaces(int spaces) {
        return TextSourceUtils.getNChars(spaces, ' ');
    }

    public static String getNChars(int count, char ch) {
        char[] array = new char[count];
        Arrays.fill(array, ch);
        return new String(array);
    }

    public static String stringNTimes(String string, int count) {
        Assert.AssertNamespace.assertTrue((count >= 0 ? 1 : 0) != 0);
        StringBuffer result = new StringBuffer(string.length() * count);
        while (count-- > 0) {
            result.append(string);
        }
        return result.toString();
    }
}

