/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.text;

import melnorme.lang.ide.core.TextSettings_Actual;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.ArrayUtil;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class LangDocumentPartitionerSetup
implements IDocumentSetupParticipant {
    public static final String[] LEGAL_CONTENT_TYPES = (String[])ArrayUtil.remove((Object[])TextSettings_Actual.PARTITION_TYPES, (Object)"__dftl_partition_content_type");
    protected static LangDocumentPartitionerSetup instance = new LangDocumentPartitionerSetup();

    public static LangDocumentPartitionerSetup getInstance() {
        return instance;
    }

    public void setup(IDocument document) {
        this.setupDocument(document);
    }

    public FastPartitioner setupDocument(IDocument document) {
        return this.setupDocumentPartitioner(document, "___go_partioning");
    }

    public FastPartitioner createDocumentPartitioner() {
        IPartitionTokenScanner scanner = TextSettings_Actual.createPartitionScanner();
        return new FastPartitioner(scanner, LEGAL_CONTENT_TYPES);
    }

    protected FastPartitioner setupDocumentPartitioner(IDocument document, String partitioning) {
        FastPartitioner partitioner = this.createDocumentPartitioner();
        LangDocumentPartitionerSetup.setupDocumentPartitioner(document, partitioning, (IDocumentPartitioner)partitioner);
        return partitioner;
    }

    public static void setupDocumentPartitioner(IDocument document, String partitioning, IDocumentPartitioner partitioner) {
        Assert.AssertNamespace.assertNotNull((Object)document);
        Assert.AssertNamespace.assertNotNull((Object)partitioning);
        Assert.AssertNamespace.assertNotNull((Object)partitioner);
        partitioner.connect(document);
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            extension3.setDocumentPartitioner(partitioning, partitioner);
        } else {
            document.setDocumentPartitioner(partitioner);
        }
    }

    public void setupPartitioningIfNotSet(IDocument document) {
        String partitioning;
        IDocumentExtension3 extension3;
        if (document instanceof IDocumentExtension3 && (extension3 = (IDocumentExtension3)document).getDocumentPartitioner(partitioning = "___go_partioning") == null) {
            FastPartitioner partitioner = this.createDocumentPartitioner();
            partitioner.connect(document);
            extension3.setDocumentPartitioner(partitioning, (IDocumentPartitioner)partitioner);
        }
    }
}

