/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.text;

import java.util.function.Function;
import melnorme.utilbox.misc.ArrayUtil;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class FullPatternRule
implements IRule {
    protected IToken token;
    protected final IWordDetector ruleCancelWordDetector;
    protected char[][] possibleSequences;
    public static final Function<String, char[]> STRING_to_CHAR_ARRAY = new Function<String, char[]>(){

        @Override
        public char[] apply(String obj) {
            return obj.toCharArray();
        }
    };

    public FullPatternRule(IToken token, String[] possibleSequences, IWordDetector ruleCancelWordDetector) {
        this.token = token;
        this.ruleCancelWordDetector = ruleCancelWordDetector;
        this.possibleSequences = (char[][])ArrayUtil.map((Object[])possibleSequences, STRING_to_CHAR_ARRAY, char[].class);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int ch = scanner.read();
        int i = 0;
        while (i < this.possibleSequences.length) {
            char[] sequence = this.possibleSequences[i];
            if (FullPatternRule.matchesSequence(scanner, ch, sequence)) {
                int endCh = scanner.read();
                scanner.unread();
                if (endCh == -1 || !this.ruleCancelWordDetector.isWordPart((char)endCh)) {
                    return this.token;
                }
                FullPatternRule.scannerUnread(scanner, sequence.length - 1);
            }
            ++i;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected static boolean matchesSequence(ICharacterScanner scanner, int firstChar, char[] sequence) {
        int ch = firstChar;
        if (ch == sequence[0]) {
            int i = 1;
            while (i < sequence.length) {
                ch = scanner.read();
                if (ch != sequence[i]) {
                    FullPatternRule.scannerUnread(scanner, i);
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected static void scannerUnread(ICharacterScanner scanner, int count) {
        while (--count >= 0) {
            scanner.unread();
        }
    }
}

