/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.text;

import melnorme.lang.ide.core.text.AbstractDocumentScanner;
import melnorme.utilbox.core.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class BlockHeuristicsScannner
extends AbstractDocumentScanner {
    protected final BlockTokenRule[] blockRules;
    protected final BlockTokenRule[] blockRulesReversed;
    protected final FnTokenAdvance prevTokenFn = new FnTokenAdvance(this){

        @Override
        protected int advanceToken() {
            return this.readPreviousCharacter();
        }

        @Override
        protected void revertToken() {
            this.revertPreviousCharacter();
        }
    };
    protected final FnTokenAdvance nextTokenFn = new FnTokenAdvance(this){

        @Override
        protected int advanceToken() {
            return this.readNextCharacter();
        }

        @Override
        protected void revertToken() {
            this.revertNextCharacter();
        }
    };

    public BlockHeuristicsScannner(IDocument document, String partitioning, String contentType, BlockTokenRule ... blockRules) {
        super(document, partitioning, contentType);
        this.blockRules = blockRules;
        this.blockRulesReversed = new BlockTokenRule[blockRules.length];
        int i = 0;
        while (i < blockRules.length) {
            BlockTokenRule blockRule = blockRules[i];
            this.blockRulesReversed[i] = new BlockTokenRule(blockRule.close, blockRule.open);
            ++i;
        }
    }

    public char getClosingPeer(char openChar) {
        return BlockHeuristicsScannner.getMatchingPeer(openChar, this.blockRules);
    }

    public char getOpeningPeer(char closeChar) {
        return BlockHeuristicsScannner.getMatchingPeer(closeChar, this.blockRulesReversed);
    }

    public boolean isClosingBrace(char closeChar) {
        BlockTokenRule[] blockTokenRuleArray = this.blockRules;
        int n = this.blockRules.length;
        int n2 = 0;
        while (n2 < n) {
            BlockTokenRule blockTokenRule = blockTokenRuleArray[n2];
            if (closeChar == blockTokenRule.close) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static char getMatchingPeer(char openChar, BlockTokenRule[] blockTokenRules) {
        int i = 0;
        while (i < blockTokenRules.length) {
            BlockTokenRule blockRule = blockTokenRules[i];
            if (blockRule.open == openChar) {
                return blockRule.close;
            }
            ++i;
        }
        throw Assert.AssertNamespace.assertFail();
    }

    protected int getPriorityOfBlockToken(char blockToken) {
        int i = 0;
        while (i < this.blockRules.length) {
            BlockTokenRule blockRule = this.blockRules[i];
            if (blockRule.open == blockToken || blockRule.close == blockToken) {
                return i;
            }
            ++i;
        }
        throw Assert.AssertNamespace.assertFail();
    }

    public BlockBalanceResult calculateBlockBalances(int beginPos, int endPos) throws BadLocationException {
        this.setScanRange(endPos, beginPos);
        BlockBalanceResult result = new BlockBalanceResult();
        block0: while (this.readPreviousCharacter() != TOKEN_EOF) {
            int i = 0;
            while (i < this.blockRules.length) {
                BlockTokenRule blockRule = this.blockRules[i];
                if (this.token == blockRule.close) {
                    int blockCloseOffset = this.getPosition();
                    int balance = this.scanToBlockPeer(i, this.prevTokenFn, this.blockRules);
                    if (balance <= 0) continue block0;
                    result.unbalancedCloses = balance;
                    result.rightmostUnbalancedBlockCloseOffset = blockCloseOffset;
                    return result;
                }
                if (this.token == blockRule.open) {
                    ++result.unbalancedOpens;
                    if (result.rightmostUnbalancedBlockOpenOffset != -1) continue block0;
                    result.rightmostUnbalancedBlockOpenOffset = this.getPosition();
                    continue block0;
                }
                ++i;
            }
        }
        return result;
    }

    public int scanToBlockStart(int blockCloseOffset) throws BadLocationException {
        char blockClose = this.document.getChar(blockCloseOffset);
        return this.scanToBlockStart(blockCloseOffset, blockClose);
    }

    public int scanToBlockStart(int blockCloseOffset, char blockClose) {
        this.setPosition(blockCloseOffset);
        this.posLimit = 0;
        return this.scanToBlockStartForChar(blockClose, this.prevTokenFn, this.blockRules);
    }

    public int scanToBlockEnd(int blockOpenOffset) throws BadLocationException {
        this.setScanRange(blockOpenOffset + 1, this.document.getLength());
        char blockOpen = this.document.getChar(blockOpenOffset);
        return this.scanToBlockEnd(blockOpen);
    }

    protected int scanToBlockEnd(char blockOpen) {
        return this.scanToBlockStartForChar(blockOpen, this.nextTokenFn, this.blockRulesReversed);
    }

    protected int scanToBlockStartForChar(char blockClose, FnTokenAdvance fnAdvance, BlockTokenRule[] blockTkRules) {
        int ix = this.getPriorityOfBlockToken(blockClose);
        return this.scanToBlockPeer(ix, fnAdvance, blockTkRules);
    }

    protected int scanToBlockPeer(int expectedTokenIx, FnTokenAdvance fnAdvance, BlockTokenRule[] blockTkRules) {
        Assert.AssertNamespace.assertTrue((expectedTokenIx >= 0 && expectedTokenIx < blockTkRules.length ? 1 : 0) != 0);
        block0: while (fnAdvance.advanceToken() != TOKEN_EOF) {
            int i = 0;
            while (i < blockTkRules.length) {
                BlockTokenRule blockRule = blockTkRules[i];
                if (this.token == blockRule.close) {
                    int pendingBlocks = this.scanToBlockPeer(i, fnAdvance, blockTkRules);
                    if (pendingBlocks <= 0) continue block0;
                    return pendingBlocks + 1;
                }
                if (this.token == blockRule.open) {
                    if (i == expectedTokenIx) {
                        return 0;
                    }
                    if (i >= expectedTokenIx) continue block0;
                    fnAdvance.revertToken();
                    this.token = TOKEN_INVALID;
                    return 0;
                }
                ++i;
            }
        }
        return 1;
    }

    public int findBlockStart(int blockCloseOffset) throws BadLocationException {
        this.scanToBlockStart(blockCloseOffset);
        return this.getPosition();
    }

    public int findBlockStart(int blockCloseOffset, char blockClose) {
        this.scanToBlockStart(blockCloseOffset, blockClose);
        return this.getPosition();
    }

    public boolean shouldCloseBlock(int blockOpenOffset) {
        Assert.AssertNamespace.assertTrue((blockOpenOffset != -1 ? 1 : 0) != 0);
        char primaryBlockOpen = this.source.charAt(blockOpenOffset);
        int primaryBlockPriority = this.getPriorityOfBlockToken(primaryBlockOpen);
        char blockOpen = primaryBlockOpen;
        int leftOffset = blockOpenOffset;
        int rightOffset = blockOpenOffset + 1;
        do {
            Assert.AssertNamespace.assertTrue((this.getPriorityOfBlockToken(blockOpen) == primaryBlockPriority ? 1 : 0) != 0);
            this.setScanRange(rightOffset, this.document.getLength());
            int balance = this.scanToBlockEnd(blockOpen);
            if (balance == 0 && this.token == TOKEN_INVALID) {
                return true;
            }
            if (balance > 0) {
                return true;
            }
            rightOffset = this.getPosition();
            this.setScanRange(leftOffset, 0);
            int balanceToTheLeft = this.findUnmatchedOpen(primaryBlockPriority);
            leftOffset = this.getPosition();
            if (balanceToTheLeft > 0) continue;
            return false;
        } while (this.getPriorityOfBlockToken(blockOpen = (char)this.token) >= primaryBlockPriority);
        return false;
    }

    protected int findUnmatchedOpen(int requiredPriority) {
        block0: while (this.prevTokenFn.advanceToken() != TOKEN_EOF) {
            int i = 0;
            while (i < this.blockRules.length) {
                BlockTokenRule blockRule = this.blockRules[i];
                if (this.token == blockRule.close) {
                    if (this.scanToBlockPeer(i, this.prevTokenFn, this.blockRules) <= 0) continue block0;
                    return -1;
                }
                if (this.token == blockRule.open && this.getPriorityOfBlockToken((char)this.token) <= requiredPriority) {
                    return 1;
                }
                ++i;
            }
        }
        return 0;
    }

    public static class BlockBalanceResult {
        public int unbalancedOpens = 0;
        public int unbalancedCloses = 0;
        public int rightmostUnbalancedBlockCloseOffset = -1;
        public int rightmostUnbalancedBlockOpenOffset = -1;
    }

    public static final class BlockTokenRule {
        public final char open;
        public final char close;

        public BlockTokenRule(char open, char close) {
            this.open = open;
            this.close = close;
        }
    }

    protected abstract class FnTokenAdvance {
        protected FnTokenAdvance() {
        }

        protected abstract int advanceToken();

        protected abstract void revertToken();
    }
}

