/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.text;

import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;

public class AbstractDocumentScanner {
    public static int TOKEN_EOF = -1;
    public static int TOKEN_INVALID = -2;
    public static int TOKEN_OUTSIDE = -3;
    protected final IDocument document;
    protected final String source;
    protected final String partitioning;
    protected final IDocumentExtension3 documentExt3;
    protected final IDocumentPartitioner partitioner;
    protected final String contentType;
    protected int pos;
    protected int posLimit;
    protected int token;
    protected ITypedRegion lastPartition = new TypedRegion(-1, 0, "__no_partition_at_all");

    protected AbstractDocumentScanner(IDocument document, String partitioning, String contentType) {
        this.document = (IDocument)Assert.AssertNamespace.assertNotNull((Object)document);
        this.partitioning = partitioning;
        this.source = document.get();
        if (partitioning == null) {
            this.contentType = "__dftl_partition_content_type";
            this.documentExt3 = null;
            this.partitioner = null;
        } else {
            Assert.isLegal((partitioning != null ? 1 : 0) != 0);
            Assert.isLegal((contentType != null ? 1 : 0) != 0);
            this.contentType = contentType;
            this.documentExt3 = (IDocumentExtension3)CoreUtil.tryCast((Object)document, IDocumentExtension3.class);
            Assert.isLegal((this.documentExt3 != null ? 1 : 0) != 0, (String)"document must support IDocumentExtension3");
            this.partitioner = this.documentExt3.getDocumentPartitioner(partitioning);
            Assert.isLegal((this.partitioner != null ? 1 : 0) != 0, (String)("document must have a partitioner for " + partitioning));
        }
    }

    public IDocument getDocument() {
        return this.document;
    }

    public int getPosition() {
        return this.pos;
    }

    protected void setPosition(int pos) {
        this.pos = pos;
    }

    public final void setScanRange(int pos, int posLimit) {
        this.pos = pos;
        this.posLimit = posLimit;
    }

    protected final int getSourceLength() {
        return this.document.getLength();
    }

    protected final int readPreviousCharacter() {
        ITypedRegion partition;
        if (this.pos <= this.posLimit) {
            this.token = TOKEN_EOF;
            return this.token;
        }
        try {
            partition = this.getPartition(this.pos - 1);
        }
        catch (BadLocationException e) {
            this.token = TOKEN_OUTSIDE;
            return this.token;
        }
        --this.pos;
        if (this.contentType.equals(partition.getType())) {
            char c = this.source.charAt(this.pos);
            this.token = c;
            return c;
        }
        this.pos = partition.getOffset();
        this.token = TOKEN_OUTSIDE;
        return this.token;
    }

    protected final int readNextCharacter() {
        ITypedRegion partition;
        if (this.pos >= this.posLimit) {
            this.token = TOKEN_EOF;
            return this.token;
        }
        int charPos = this.pos++;
        try {
            partition = this.getPartition(charPos);
        }
        catch (BadLocationException e) {
            this.token = TOKEN_OUTSIDE;
            return this.token;
        }
        if (this.contentType.equals(partition.getType())) {
            char c = this.source.charAt(charPos);
            this.token = c;
            return c;
        }
        this.pos = partition.getOffset() + partition.getLength();
        this.token = TOKEN_OUTSIDE;
        return this.token;
    }

    protected final void revertPreviousCharacter() {
        ++this.pos;
    }

    protected final void revertNextCharacter() {
        --this.pos;
    }

    public ITypedRegion getPartition(int position) throws BadLocationException {
        if (!AbstractDocumentScanner.partitionContainsPosition((IRegion)this.lastPartition, position)) {
            if (this.documentExt3 != null) {
                try {
                    this.lastPartition = this.documentExt3.getPartition(this.partitioning, position, false);
                }
                catch (BadPartitioningException e) {
                    throw Assert.AssertNamespace.assertFail();
                }
            } else {
                this.lastPartition = this.document.getPartition(position);
            }
        }
        return this.lastPartition;
    }

    public static boolean partitionContainsPosition(IRegion region, int position) {
        return region.getOffset() <= position && position < region.getOffset() + region.getLength();
    }
}

