/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.project_model;

import melnorme.lang.ide.core.project_model.BundleManifestResourceListener;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.tooling.BundlePath;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.core.fntypes.RunnableX;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.ownership.IOwner;
import melnorme.utilbox.ownership.LifecycleObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class ProjectBasedModelManager
extends LifecycleObject {
    protected final BundleManifestResourceListener listener = this.init_createResourceListener();

    protected void initializeModelManager() {
        ResourceUtils.connectResourceListener(this.listener, (RunnableX<CoreException>)((RunnableX)this::initializeProjectsInfo), (ISchedulingRule)ResourceUtils.getWorkspaceRoot(), (IOwner)this.owned);
    }

    public final void shutdownManager() {
        this.dispose();
    }

    protected void initializeProjectsInfo() {
        IProject[] projects;
        IProject[] iProjectArray = projects = EclipseUtils.getWorkspaceRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this.listener.isValidLangProject(project) && this.listener.isValidBundleModelProject(project)) {
                this.bundleProjectAdded(project);
            }
            ++n2;
        }
    }

    protected abstract BundleManifestResourceListener init_createResourceListener();

    protected abstract Object getProjectInfo(IProject var1);

    protected abstract void bundleProjectAdded(IProject var1);

    protected abstract void bundleProjectRemoved(IProject var1);

    protected abstract void bundleManifestFileChanged(IProject var1);

    public boolean resourceIsManifest(IResource resource) {
        if (resource == null || resource.getType() != 1) {
            return false;
        }
        try {
            Location projectLoc = ResourceUtils.getLocation((IResource)resource.getProject());
            Location resourceLoc = ResourceUtils.getLocation(resource);
            return CoreUtil.areEqual((Object)new BundlePath(projectLoc).getManifestLocation(true), (Object)resourceLoc);
        }
        catch (CommonException e) {
            return false;
        }
    }

    protected class ManagerResourceListener
    extends BundleManifestResourceListener {
        @Override
        public Object getProjectInfo(IProject project) {
            return ProjectBasedModelManager.this.getProjectInfo(project);
        }

        @Override
        public void bundleProjectAdded(IProject project) {
            ProjectBasedModelManager.this.bundleProjectAdded(project);
        }

        @Override
        public void bundleProjectRemoved(IProject project) {
            ProjectBasedModelManager.this.bundleProjectRemoved(project);
        }

        @Override
        public void bundleManifestChanged(IProject project) {
            ProjectBasedModelManager.this.bundleManifestFileChanged(project);
        }

        @Override
        public boolean resourceIsManifest(IResource resource) {
            return ProjectBasedModelManager.this.resourceIsManifest(resource);
        }
    }
}

