/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.operations.build;

import java.util.Collections;
import java.util.Map;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.operations.build.BuildTarget;
import melnorme.lang.ide.core.operations.build.BuildTargetData;
import melnorme.lang.tooling.bundle.BuildConfiguration;
import melnorme.lang.tooling.bundle.BundleInfo;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Collection2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.collections.LinkedHashMap2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusException;
import org.eclipse.core.resources.IProject;

public class ProjectBuildInfo {
    protected final BuildManager buildMgr;
    protected final IProject project;
    protected final LinkedHashMap2<String, BuildTarget> buildTargets = new LinkedHashMap2();
    protected final BundleInfo bundleInfo;

    public ProjectBuildInfo(BuildManager buildManager, IProject project, BundleInfo bundleInfo, Indexable<BuildTarget> buildTargets) {
        this.buildMgr = buildManager;
        this.project = project;
        this.bundleInfo = (BundleInfo)Assert.AssertNamespace.assertNotNull((Object)bundleInfo);
        for (BuildTarget buildTarget : CoreUtil.nullToEmpty(buildTargets)) {
            this.buildTargets.put((Object)buildTarget.getBuildTargetName(), (Object)buildTarget);
        }
    }

    public BuildManager getBuildManager() {
        return this.buildMgr;
    }

    public IProject getProject() {
        return this.project;
    }

    public BundleInfo getBundleInfo() {
        return this.bundleInfo;
    }

    public Collection2<BuildTarget> getBuildTargets() {
        return this.buildTargets.getValuesView();
    }

    public BuildTarget getDefinedBuildTarget(String targetName) {
        return (BuildTarget)((Object)this.buildTargets.get((Object)targetName));
    }

    public Map<String, BuildTarget> getBuildTargetsMap() {
        return Collections.unmodifiableMap(this.buildTargets);
    }

    public BuildTarget getDefaultBuildTarget() throws CommonException {
        if (this.buildTargets.size() == 0) {
            throw new CommonException("No targets available");
        }
        return (BuildTarget)((Object)((Map.Entry)this.buildTargets.iterator().next()).getValue());
    }

    public ArrayList2<BuildTarget> getEnabledTargets(boolean normalBuild) {
        ArrayList2 enabledTargets = ArrayList2.create();
        for (BuildTarget buildTarget : CoreUtil.nullToEmpty(this.getBuildTargets())) {
            if ((!normalBuild || !buildTarget.isNormalBuildEnabled()) && (normalBuild || !buildTarget.isAutoBuildEnabled())) continue;
            enabledTargets.add((Object)buildTarget);
        }
        return enabledTargets;
    }

    public Indexable<BuildConfiguration> getBuildConfigs() {
        return this.getBundleInfo().getBuildConfigurations();
    }

    public BuildTarget getDefaultBuildTarget(String targetName) {
        Assert.AssertNamespace.assertNotNull((Object)targetName);
        ArrayList2<BuildTarget> defaultBuildTargets = this.buildMgr.getDefaultBuildTargets(this.project, this.bundleInfo);
        return (BuildTarget)((Object)defaultBuildTargets.findElement(elem -> targetName.equals(elem.getTargetName())));
    }

    public ProjectBuildInfo getUpdatedInfo() {
        return this.buildMgr.getBuildInfo(this.project);
    }

    public final void changeEnable(String buildTargetName, boolean newNormalBuildEnabled, boolean newAutoBuildEnabled) throws CommonException {
        BuildTarget oldBuildTarget = this.buildMgr.getDefinedBuildTarget(this.project, buildTargetName);
        BuildTargetData buildTargetData = oldBuildTarget.getDataCopy();
        buildTargetData.normalBuildEnabled = newNormalBuildEnabled;
        buildTargetData.autoBuildEnabled = newAutoBuildEnabled;
        this.changeBuildTarget(buildTargetName, buildTargetData);
    }

    public void changeBuildTarget(String buildTargetName, BuildTargetData buildTargetData) throws CommonException {
        this.changeBuildTarget(buildTargetName, this.buildMgr.createBuildTarget(this.project, buildTargetData));
    }

    protected void changeBuildTarget(String buildTargetName, BuildTarget newBuildTarget) throws CommonException {
        ProjectBuildInfo newProjectBuildInfo = this.copyWithModifiedBuildTarget(buildTargetName, newBuildTarget);
        this.buildMgr.tryUpdateProjectBuildInfo(this.project, this, newProjectBuildInfo);
        this.buildMgr.saveProjectInfo(this.project);
    }

    protected ProjectBuildInfo copyWithModifiedBuildTarget(String buildTargetName, BuildTarget newBuildTarget) throws CommonException, StatusException {
        boolean mutated = false;
        ArrayList2 newBuildTargets = new ArrayList2(this.buildTargets.size());
        for (BuildTarget buildTargetCursor : this.getBuildTargets()) {
            if (buildTargetCursor.getTargetName().equals(buildTargetName)) {
                newBuildTargets.add((Object)newBuildTarget);
                mutated = true;
                continue;
            }
            newBuildTargets.add((Object)this.buildMgr.createBuildTarget(this.project, buildTargetCursor.getData()));
        }
        if (!mutated) {
            throw new StatusException(Severity.WARNING, "Could not change build target settings, the build target to be changed is out of date.");
        }
        return new ProjectBuildInfo(this.buildMgr, this.project, this.bundleInfo, (Indexable<BuildTarget>)newBuildTargets);
    }
}

