/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.operations.build;

import melnorme.lang.ide.core.operations.AbstractToolManagerOperation;
import melnorme.lang.ide.core.operations.ILangOperationsListener_Default;
import melnorme.lang.ide.core.operations.ToolManager;
import melnorme.lang.ide.core.operations.build.VariablesResolver;
import melnorme.lang.tooling.commands.CommandInvocation;
import melnorme.lang.tooling.commands.IVariablesResolver;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.process.ExternalProcessHelper;
import org.eclipse.core.resources.IProject;

public abstract class BuildTargetOperation
extends AbstractToolManagerOperation {
    protected final ILangOperationsListener_Default.IToolOperationMonitor opMonitor;
    protected final String buildTargetName;
    protected final CommandInvocation buildCommand;

    public BuildTargetOperation(BuildOperationParameters buildOpParams) {
        super(buildOpParams.toolManager, buildOpParams.project);
        Assert.AssertNamespace.assertNotNull((Object)this.project);
        this.opMonitor = (ILangOperationsListener_Default.IToolOperationMonitor)Assert.AssertNamespace.assertNotNull((Object)buildOpParams.opMonitor);
        this.buildTargetName = (String)Assert.AssertNamespace.assertNotNull((Object)buildOpParams.buildTargetName);
        this.buildCommand = (CommandInvocation)Assert.AssertNamespace.assertNotNull((Object)buildOpParams.buildCommand);
    }

    public String getBuildTargetName() {
        return this.buildTargetName;
    }

    public void execute(IOperationMonitor parentOM) throws CommonException, OperationCancellation {
        parentOM.runSubTask(this.getBuildOperationName(), om -> {
            ProcessBuilder pb = this.getToolProcessBuilder();
            this.runBuildToolAndProcessOutput(pb, om);
        });
    }

    protected String getBuildOperationName() {
        return "Building " + this.getBuildTargetName();
    }

    public Iterable<String> getEffectiveProccessCommandLine() throws CommonException {
        return this.getConfiguredProcessBuilder2().command();
    }

    public ProcessBuilder getConfiguredProcessBuilder2() throws CommonException {
        VariablesResolver variablesManager = this.toolManager.getVariablesManager(CoreUtil.option((Object)this.getProject()));
        ProcessBuilder pb = this.buildCommand.getProcessBuilder((IVariablesResolver)variablesManager);
        pb.directory(this.getProjectLocation().toFile());
        return pb;
    }

    public ProcessBuilder getToolProcessBuilder() throws CommonException, OperationCancellation {
        return this.getToolManager().modifyToolProcessBuilder(this.getConfiguredProcessBuilder2());
    }

    public void runBuildToolAndProcessOutput(ProcessBuilder pb, IOperationMonitor om) throws CommonException, OperationCancellation {
        this.processBuildOutput(this.runBuildTool(this.opMonitor, pb, om), om);
    }

    protected abstract void processBuildOutput(ExternalProcessHelper.ExternalProcessResult var1, IOperationMonitor var2) throws CommonException, OperationCancellation;

    public static class BuildOperationParameters {
        public ILangOperationsListener_Default.IToolOperationMonitor opMonitor;
        public ToolManager toolManager;
        public IProject project;
        public String buildTargetName;
        public CommandInvocation buildCommand;

        public BuildOperationParameters(ILangOperationsListener_Default.IToolOperationMonitor opMonitor, ToolManager toolManager, IProject project, String buildTargetName, CommandInvocation buildCommand) {
            this.opMonitor = opMonitor;
            this.toolManager = toolManager;
            this.project = project;
            this.buildTargetName = buildTargetName;
            this.buildCommand = buildCommand;
        }
    }
}

