/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.operations.build;

import melnorme.lang.ide.core.operations.build.BuildTargetDataView;
import melnorme.lang.tooling.commands.CommandInvocation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.HashcodeUtil;

public class BuildTargetData
implements BuildTargetDataView {
    public String targetName;
    public boolean normalBuildEnabled;
    public boolean autoBuildEnabled;
    public CommandInvocation buildCommand;
    public String executablePath;

    public BuildTargetData() {
    }

    public BuildTargetData(String targetName, boolean normalBuildEnabled, boolean autoBuildEnabled) {
        this.targetName = targetName;
        this.normalBuildEnabled = normalBuildEnabled;
        this.autoBuildEnabled = autoBuildEnabled;
    }

    public BuildTargetData(String targetName, boolean normalBuildEnabled, boolean autoBuildEnabled, CommandInvocation buildCommand, String executablePath) {
        this(targetName, normalBuildEnabled, autoBuildEnabled);
        this.buildCommand = buildCommand;
        this.executablePath = executablePath;
    }

    public BuildTargetData setData(BuildTargetDataView data) {
        this.targetName = data.getTargetName();
        this.normalBuildEnabled = data.isNormalBuildEnabled();
        this.autoBuildEnabled = data.isAutoBuildEnabled();
        this.buildCommand = data.getBuildCommand();
        this.executablePath = data.getExecutablePath();
        Assert.AssertNamespace.assertAreEqual((Object)this, (Object)data);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BuildTargetData)) {
            return false;
        }
        BuildTargetData other = (BuildTargetData)obj;
        return CoreUtil.areEqual((Object)this.targetName, (Object)other.targetName) && CoreUtil.areEqual((Object)this.normalBuildEnabled, (Object)other.normalBuildEnabled) && CoreUtil.areEqual((Object)this.autoBuildEnabled, (Object)other.autoBuildEnabled) && CoreUtil.areEqual((Object)this.buildCommand, (Object)other.buildCommand) && CoreUtil.areEqual((Object)this.executablePath, (Object)other.executablePath);
    }

    public int hashCode() {
        return HashcodeUtil.combinedHashCode((Object[])new Object[]{this.targetName, this.normalBuildEnabled, this.autoBuildEnabled, this.buildCommand});
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public boolean isNormalBuildEnabled() {
        return this.normalBuildEnabled;
    }

    @Override
    public boolean isAutoBuildEnabled() {
        return this.autoBuildEnabled;
    }

    @Override
    public CommandInvocation getBuildCommand() {
        return this.buildCommand;
    }

    @Override
    public String getExecutablePath() {
        return this.executablePath;
    }
}

