/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.operations.build;

import java.text.MessageFormat;
import java.util.concurrent.Callable;
import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.operations.ILangOperationsListener_Default;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.operations.build.BuildManagerMessages;
import melnorme.lang.ide.core.operations.build.CompositeBuildOperation;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.core.utils.TextMessageUtils;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.lang.tooling.common.ops.Operation;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Collection2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class BuildOperationCreator
implements BuildManagerMessages {
    protected final BuildManager buildMgr = LangCore.getBuildManager();
    protected final String buildProblemId = "com.googlecode.goclipse.core.goProblem";
    protected final IProject project;
    protected final ILangOperationsListener_Default.IToolOperationMonitor opMonitor;
    protected ArrayList2<Operation> operations;

    public BuildOperationCreator(IProject project, ILangOperationsListener_Default.IToolOperationMonitor opMonitor) {
        this.project = project;
        this.opMonitor = (ILangOperationsListener_Default.IToolOperationMonitor)Assert.AssertNamespace.assertNotNull((Object)opMonitor);
    }

    public Operation newClearBuildMarkersOperation() {
        return this.doCreateClearBuildMarkersOperation();
    }

    public CompositeBuildOperation newProjectBuildOperation(Collection2<Operation> buildOps, boolean clearMarkers) throws CommonException {
        this.operations = ArrayList2.create();
        if (buildOps.isEmpty()) {
            return new CompositeBuildOperation(this.opMonitor, (Indexable<Operation>)this.operations, null);
        }
        this.addCompositeBuildOperationMessage();
        if (clearMarkers) {
            this.addOperation(this.newClearBuildMarkersOperation());
        }
        if (buildOps.isEmpty()) {
            this.addOperation(this.newMessageOperation(TextMessageUtils.headerSMALL("No build targets enabled.")));
        }
        for (Operation buildOp : buildOps) {
            this.addOperation(buildOp);
        }
        this.addOperation(new Operation(){

            public void execute(IOperationMonitor om) throws CommonException, OperationCancellation {
                try {
                    BuildOperationCreator.this.project.refreshLocal(2, EclipseUtils.pm((ICancelMonitor)om));
                }
                catch (CoreException e) {
                    throw EclipseUtils.createCommonException(e);
                }
            }
        });
        this.addOperation(this.newMessageOperation(TextMessageUtils.headerBIG("Build terminated.")));
        IWorkspaceRoot rule = ResourceUtils.getWorkspaceRoot();
        return new CompositeBuildOperation(this.opMonitor, (Indexable<Operation>)this.operations, (ISchedulingRule)rule);
    }

    protected boolean addOperation(Operation toolOp) {
        return this.operations.add((Object)toolOp);
    }

    protected void addCompositeBuildOperationMessage() throws CommonException {
        String startMsg = TextMessageUtils.headerBIG(MessageFormat.format("Building {0} project: {1}", "Go", this.project.getName()));
        this.addOperation(this.newMessageOperation(startMsg));
    }

    protected Operation doCreateClearBuildMarkersOperation() {
        return om -> {
            boolean hadDeletedMarkers = this.doDeleteProjectMarkers("com.googlecode.goclipse.core.goProblem", om);
            if (hadDeletedMarkers) {
                this.opMonitor.writeInfoMessage(String.valueOf(MessageFormat.format("Cleared problem markers for {0}.", this.project.getName())) + "\n");
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doDeleteProjectMarkers(String markerType, IOperationMonitor parentOM) throws OperationCancellation {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            block8: {
                IOperationMonitor.IOperationSubMonitor om = parentOM.enterSubTask("Clearing problem markers");
                try {
                    IMarker[] findMarkers = this.project.findMarkers(markerType, true, 2);
                    parentOM.checkCancellation();
                    if (findMarkers.length == 0) return false;
                    this.project.deleteMarkers(markerType, true, 2);
                    if (om == null) break block8;
                }
                catch (CoreException ce) {
                    EclipseCore.logStatus(ce);
                    return false;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                om.close();
            }
            return true;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    protected Operation newMessageOperation(String msg) {
        return new BuildMessageOperation(msg);
    }

    protected class BuildMessageOperation
    implements Operation,
    Callable<Void> {
        protected final String msg;

        public BuildMessageOperation(String msg) {
            this.msg = msg;
        }

        public void execute(IOperationMonitor monitor) {
            this.executeDo();
        }

        protected void executeDo() {
            this.call();
        }

        @Override
        public Void call() throws RuntimeException {
            BuildOperationCreator.this.opMonitor.writeInfoMessage(this.msg);
            return null;
        }
    }
}

