/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.operations.build;

import java.util.HashMap;
import java.util.Map;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.operations.ILangOperationsListener_Default;
import melnorme.lang.ide.core.operations.ToolManager;
import melnorme.lang.ide.core.operations.build.BuildManagerMessages;
import melnorme.lang.ide.core.operations.build.BuildOperationCreator;
import melnorme.lang.ide.core.operations.build.BuildTarget;
import melnorme.lang.ide.core.operations.build.BuildTargetData;
import melnorme.lang.ide.core.operations.build.BuildTargetDataView;
import melnorme.lang.ide.core.operations.build.BuildTargetOperation;
import melnorme.lang.ide.core.operations.build.BuildTargetsSerializer;
import melnorme.lang.ide.core.operations.build.CompositeBuildOperation;
import melnorme.lang.ide.core.operations.build.ProjectBuildInfo;
import melnorme.lang.ide.core.operations.build.VariablesResolver;
import melnorme.lang.ide.core.project_model.IProjectModelListener;
import melnorme.lang.ide.core.project_model.LangBundleModel;
import melnorme.lang.ide.core.project_model.ProjectBasedModel;
import melnorme.lang.ide.core.project_model.UpdateEvent;
import melnorme.lang.ide.core.utils.ProjectValidator;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.core.utils.prefs.IProjectPreference;
import melnorme.lang.ide.core.utils.prefs.StringPreference;
import melnorme.lang.tooling.bundle.BuildConfiguration;
import melnorme.lang.tooling.bundle.BuildTargetNameParser;
import melnorme.lang.tooling.bundle.BundleInfo;
import melnorme.lang.tooling.bundle.LaunchArtifact;
import melnorme.lang.tooling.common.ops.Operation;
import melnorme.lang.utils.EnablementCounter;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Collection2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.SimpleLogger;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.status.StatusException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;

public abstract class BuildManager {
    public static final SimpleLogger log = new SimpleLogger(Platform.inDebugMode());
    protected final BuildModel buildModel;
    protected final LangBundleModel bundleModel;
    protected final ToolManager toolManager;
    protected Object init_Lock = new Object();
    protected final IProjectModelListener<BundleInfo> listener = new IProjectModelListener<BundleInfo>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyUpdateEvent(UpdateEvent<BundleInfo> updateEvent) {
            Object object = BuildManager.this.init_Lock;
            synchronized (object) {
                if (updateEvent.newProjectInfo2 != null) {
                    BuildManager.this.bundleProjectAddedOrModified(updateEvent.project, (BundleInfo)updateEvent.newProjectInfo2);
                } else {
                    BuildManager.this.bundleProjectRemoved(updateEvent.project);
                }
            }
        }
    };
    protected static final IProjectPreference<String> BUILD_TARGETS_DATA = new StringPreference("build_targets", "").getProjectPreference();
    protected final Indexable<BuildType> buildTypes = this.initBuildTypes();
    protected final EnablementCounter autoBuildsEnablement = new EnablementCounter();

    public static BuildManager getInstance() {
        return LangCore.getBuildManager();
    }

    public BuildManager(LangBundleModel bundleModel, ToolManager toolManager) {
        this(new BuildModel(), bundleModel, toolManager);
    }

    public BuildManager(BuildModel buildModel, LangBundleModel bundleModel, ToolManager toolManager) {
        this(buildModel, bundleModel, toolManager, true);
    }

    public BuildManager(BuildModel buildModel, LangBundleModel bundleModel, ToolManager toolManager, boolean initialize) {
        this.buildModel = (BuildModel)Assert.AssertNamespace.assertNotNull((Object)buildModel);
        this.bundleModel = (LangBundleModel)Assert.AssertNamespace.assertNotNull((Object)bundleModel);
        this.toolManager = (ToolManager)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)toolManager)));
        if (initialize) {
            this.initialize(bundleModel);
        }
    }

    public ToolManager getToolManager() {
        return this.toolManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(LangBundleModel bundleModel) {
        Object object = this.init_Lock;
        synchronized (object) {
            HashMap<String, BundleInfo> projectInfos = bundleModel.connectListener(this.listener);
            for (Map.Entry<String, BundleInfo> entry : projectInfos.entrySet()) {
                IProject project = ResourceUtils.getProject(entry.getKey());
                BundleInfo bundleInfo = entry.getValue();
                this.bundleProjectAddedOrModified(project, bundleInfo);
            }
        }
    }

    public void dispose() {
        this.bundleModel.removeListener(this.listener);
    }

    public BuildModel getBuildModel() {
        return this.buildModel;
    }

    public ProjectBuildInfo getBuildInfo(IProject project) {
        return (ProjectBuildInfo)this.buildModel.getProjectInfo((IProject)Assert.AssertNamespace.assertNotNull((Object)project));
    }

    public ProjectBuildInfo getValidBuildInfo(IProject project) throws CommonException {
        return this.getValidBuildInfo(project, true);
    }

    public ProjectBuildInfo getValidBuildInfo(IProject project, boolean requireNonEmtpyTargets) throws CommonException {
        new ProjectValidator().checkProjectNotNull(project);
        ProjectBuildInfo buildInfo = this.getBuildInfo(project);
        if (buildInfo == null || requireNonEmtpyTargets && buildInfo.getBuildTargets().isEmpty()) {
            throw new CommonException("No build targets available for project.");
        }
        return buildInfo;
    }

    protected BuildTargetsSerializer createSerializer() {
        return new BuildTargetsSerializer();
    }

    protected String getBuildTargetsPref(IProject project) {
        return StringUtil.emptyAsNull((String)BUILD_TARGETS_DATA.getStoredValue(CoreUtil.option((Object)project)));
    }

    protected void bundleProjectAddedOrModified(IProject project, BundleInfo newBundleInfo) {
        this.loadProjectBuildInfo(project, newBundleInfo);
    }

    protected void bundleProjectRemoved(IProject project) {
        this.buildModel.removeProjectInfo(project);
    }

    public ProjectBuildInfo setProjectBuildInfo(IProject project, ProjectBuildInfo newProjectBuildInfo) {
        return this.buildModel.setProjectInfo(project, newProjectBuildInfo);
    }

    public void tryUpdateProjectBuildInfo(IProject project, ProjectBuildInfo oldInfo, ProjectBuildInfo newInfo) throws CommonException {
        boolean success = this.buildModel.updateProjectInfo(project, oldInfo, newInfo);
        if (!success) {
            throw new CommonException("Could not change build target settings, the build target to be changed is out of date.");
        }
    }

    protected void loadProjectBuildInfo(IProject project, BundleInfo newBundleInfo) {
        Assert.AssertNamespace.assertNotNull((Object)project);
        Assert.AssertNamespace.assertNotNull((Object)newBundleInfo);
        ProjectBuildInfo currentBuildInfo = (ProjectBuildInfo)this.buildModel.getProjectInfo(project);
        Map<String, BuildTarget> existingBuildTargets = currentBuildInfo != null ? currentBuildInfo.getBuildTargetsMap() : this.getStoredTargetSettings(project);
        ArrayList2<BuildTarget> buildTargets = this.createBuildTargetsForNewBundleInfo(project, newBundleInfo, existingBuildTargets);
        ProjectBuildInfo newBuildInfo = new ProjectBuildInfo(this, project, newBundleInfo, (Indexable<BuildTarget>)buildTargets);
        this.setProjectBuildInfo(project, newBuildInfo);
    }

    protected Map<String, BuildTarget> getStoredTargetSettings(IProject project) {
        HashMap<String, BuildTarget> existingBuildTargets = new HashMap<String, BuildTarget>();
        String targetsPrefValue = this.getBuildTargetsPref(project);
        if (targetsPrefValue != null) {
            ArrayList2<BuildTargetData> buildTargetsData;
            try {
                buildTargetsData = this.createSerializer().readFromString(targetsPrefValue);
            }
            catch (CommonException ce) {
                LangCore.logError("Error reading project build-info.", ce);
                return existingBuildTargets;
            }
            for (BuildTargetData buildTargetData : buildTargetsData) {
                BuildTarget buildTarget;
                try {
                    buildTarget = this.createBuildTarget(project, buildTargetData);
                }
                catch (CommonException ce) {
                    LangCore.logWarning("Invalid build target.", ce);
                    continue;
                }
                existingBuildTargets.put(buildTargetData.getTargetName(), buildTarget);
            }
        }
        return existingBuildTargets;
    }

    protected final ArrayList2<BuildTarget> createBuildTargetsForNewBundleInfo(IProject project, BundleInfo newBundleInfo, Map<String, BuildTarget> currentBuildTargets) {
        ArrayList2<BuildTarget> buildTargets = this.getDefaultBuildTargets(project, newBundleInfo);
        int ix = 0;
        while (ix < buildTargets.size()) {
            BuildTarget buildTarget = (BuildTarget)((Object)buildTargets.get(ix));
            BuildTarget currentBuildTarget = currentBuildTargets.get(buildTarget.getTargetName());
            if (currentBuildTarget != null) {
                buildTargets.set(ix, (Object)this.createBuildTargetForNewBundleInfo(newBundleInfo, buildTarget, currentBuildTarget.getDataCopy()));
            }
            ++ix;
        }
        return buildTargets;
    }

    protected BuildTarget createBuildTargetForNewBundleInfo(BundleInfo newBundleInfo, BuildTarget defaultBuildTarget, BuildTargetData btd) {
        return new BuildTarget(defaultBuildTarget.getProject(), newBundleInfo, btd, defaultBuildTarget.getBuildType(), defaultBuildTarget.getBuildConfiguration());
    }

    protected ArrayList2<BuildTarget> getDefaultBuildTargets(IProject project, BundleInfo newBundleInfo) {
        ArrayList2 buildTargets = new ArrayList2();
        boolean isFirstConfig = true;
        Indexable buildConfigs = newBundleInfo.getBuildConfigurations();
        for (BuildConfiguration buildConfig : buildConfigs) {
            for (BuildType buildType : this.getBuildTypes()) {
                String targetName = this.getBuildTargetName2(buildConfig.getName(), buildType.getName());
                BuildTargetData newBuildTargetData = new BuildTargetData(targetName, isFirstConfig, false);
                this.addDefaultBuildTarget((ArrayList2<BuildTarget>)buildTargets, project, newBundleInfo, buildConfig, buildType, newBuildTargetData);
                isFirstConfig = false;
            }
        }
        return buildTargets;
    }

    protected void addDefaultBuildTarget(ArrayList2<BuildTarget> buildTargets, IProject project, BundleInfo bundleInfo, BuildConfiguration buildConfig, BuildType buildType, BuildTargetData btd) {
        buildTargets.add((Object)new BuildTarget(project, bundleInfo, btd, buildType, buildConfig));
    }

    public void saveProjectInfo(IProject project) {
        ProjectBuildInfo projectInfo = (ProjectBuildInfo)this.buildModel.getProjectInfo(project);
        try {
            String data = this.createSerializer().writeProjectBuildInfo(projectInfo);
            BUILD_TARGETS_DATA.setValue(project, data);
        }
        catch (CommonException e) {
            LangCore.logError("Error persisting project build info: ", e);
        }
    }

    protected final Indexable<BuildType> initBuildTypes() {
        Indexable<BuildType> buildTypes = this.getBuildTypes_do();
        Assert.AssertNamespace.assertTrue((buildTypes.size() > 0 ? 1 : 0) != 0);
        Assert.AssertNamespace.assertTrue((!buildTypes.contains(null) ? 1 : 0) != 0);
        return buildTypes;
    }

    protected abstract Indexable<BuildType> getBuildTypes_do();

    public Indexable<BuildType> getBuildTypes() {
        return this.buildTypes;
    }

    public BuildType getBuildType_NonNull(String buildTypeName) throws CommonException {
        if (buildTypeName == null || buildTypeName.isEmpty()) {
            return this.getDefaultBuildType();
        }
        for (BuildType buildType : this.buildTypes) {
            if (!CoreUtil.areEqual((Object)buildType.getName(), (Object)buildTypeName)) continue;
            return buildType;
        }
        throw new CommonException(BuildManagerMessages.BuildType_NotFound(buildTypeName));
    }

    public BuildType getDefaultBuildType() {
        return (BuildType)this.getBuildTypes().get(0);
    }

    public BuildTargetNameParser getBuildTargetNameParser() {
        return new BuildTargetNameParser();
    }

    public final String getDefaultBuildTypeName() {
        return this.getDefaultBuildType().getName();
    }

    public String getBuildTargetName2(String buildConfigName, String buildTypeName) {
        Assert.AssertNamespace.assertNotNull((Object)buildConfigName);
        return this.getBuildTargetNameParser().getFullName(buildConfigName, buildTypeName);
    }

    public String getResolvedBuildTargetName(String buildTargetName) {
        BuildTargetNameParser nameParser = this.getBuildTargetNameParser();
        String buildConfig = nameParser.getBuildConfig(buildTargetName);
        String buildType = nameParser.getBuildType(buildTargetName);
        if (buildType == null) {
            buildType = this.getDefaultBuildTypeName();
        }
        return nameParser.getFullName(buildConfig, buildType);
    }

    public BuildTarget createBuildTarget(IProject project, BuildTargetDataView buildTargetData) throws CommonException {
        Assert.AssertNamespace.assertNotNull((Object)buildTargetData.getTargetName());
        String targetName = buildTargetData.getTargetName();
        Assert.AssertNamespace.assertNotNull((Object)targetName);
        BuildTargetNameParser nameParser = this.getBuildTargetNameParser();
        String buildConfigName = nameParser.getBuildConfig(targetName);
        BuildType buildType = this.getBuildType_NonNull(nameParser.getBuildType(targetName));
        BundleInfo bundleInfo = (BundleInfo)this.bundleModel.getBundleInfo(project);
        return BuildTarget.create(project, bundleInfo, buildTargetData, buildType, buildConfigName);
    }

    public BuildTarget getDefinedBuildTarget(IProject project, String buildTargetName) throws CommonException {
        return this.getBuildTarget(project, buildTargetName, true, true);
    }

    public BuildTarget getBuildTarget(IProject project, String buildTargetName, boolean definedTargetsOnly) throws CommonException, StatusException {
        return this.getBuildTarget(project, buildTargetName, definedTargetsOnly, true);
    }

    public final BuildTarget getBuildTarget(IProject project, String buildTargetName, boolean definedTargetsOnly, boolean requireNonNull) throws CommonException {
        ProjectBuildInfo buildInfo = this.getValidBuildInfo(project, false);
        return this.getBuildTarget_x(buildInfo, buildTargetName, definedTargetsOnly, requireNonNull);
    }

    protected void validateBuildTargetName(String buildTargetName) throws CommonException {
        if (buildTargetName == null || buildTargetName.isEmpty()) {
            throw new CommonException("Build target not specified");
        }
    }

    public BuildTarget getBuildTarget_x(ProjectBuildInfo buildInfo, String buildTargetName, boolean definedTargetsOnly, boolean requireNonNull) throws CommonException {
        this.validateBuildTargetName(buildTargetName);
        BuildTarget buildTarget = buildInfo.getDefinedBuildTarget(buildTargetName);
        if (buildTarget == null) {
            if (!definedTargetsOnly) {
                buildTarget = this.createBuildTarget(buildInfo.getProject(), new BuildTargetData(buildTargetName, false, false));
            } else if (requireNonNull) {
                throw new CommonException("Build target does not exist");
            }
        }
        return buildTarget;
    }

    public BuildTarget getFirstDefinedBuildTarget(IProject project, BuildType buildType) throws CommonException {
        ProjectBuildInfo buildInfo = this.getBuildInfo(project);
        Assert.AssertNamespace.assertNotNull((Object)buildType);
        BuildTarget foundBT = (BuildTarget)((Object)buildInfo.getBuildTargets().findElement(bt -> bt.getBuildType() == buildType));
        if (foundBT == null) {
            throw CommonException.fromMsgFormat((String)"No Build Target found for build type `{0}`. ", (Object[])new Object[]{buildType.getName()});
        }
        return foundBT;
    }

    public EnablementCounter autoBuildsEnablement() {
        return this.autoBuildsEnablement;
    }

    protected BuildOperationCreator createBuildOperationCreator(ILangOperationsListener_Default.IToolOperationMonitor opMonitor, IProject project) {
        return new BuildOperationCreator(project, opMonitor);
    }

    public Operation newProjectClearMarkersOperation(ILangOperationsListener_Default.IToolOperationMonitor opMonitor, IProject project) {
        return this.createBuildOperationCreator(opMonitor, project).newClearBuildMarkersOperation();
    }

    public final CompositeBuildOperation newBuildTargetOperation(IProject project, BuildTarget buildTarget) throws CommonException {
        return this.newBuildTargetsOperation(project, (Collection2<BuildTarget>)ArrayList2.create((Object[])new BuildTarget[]{buildTarget}));
    }

    public final CompositeBuildOperation newBuildTargetsOperation(IProject project, Collection2<BuildTarget> targetsToBuild) throws CommonException {
        ILangOperationsListener_Default.IToolOperationMonitor buildOp = this.getToolManager().startNewBuildOperation();
        return this.newBuildOperation(buildOp, project, true, targetsToBuild);
    }

    public final Operation newProjectBuildOperation(ILangOperationsListener_Default.IToolOperationMonitor opMonitor, IProject project, boolean clearMarkers, boolean isAuto) throws CommonException {
        ArrayList2<BuildTarget> enabledTargets = this.getValidBuildInfo(project).getEnabledTargets(!isAuto);
        if (isAuto && enabledTargets.isEmpty()) {
            return Operation.NULL_COMMON_OPERATION;
        }
        return this.newBuildOperation(opMonitor, project, clearMarkers, (Collection2<BuildTarget>)enabledTargets);
    }

    public CompositeBuildOperation newBuildOperation(ILangOperationsListener_Default.IToolOperationMonitor opMonitor, IProject project, boolean clearMarkers, Collection2<BuildTarget> targetsToBuild) throws CommonException {
        Assert.AssertNamespace.assertNotNull((Object)opMonitor);
        ArrayList2 buildCommands = targetsToBuild.mapx(buildTarget -> buildTarget.getBuildOperation(this.toolManager, opMonitor));
        return this.newTopLevelBuildOperation(opMonitor, project, clearMarkers, (Collection2<Operation>)buildCommands);
    }

    public CompositeBuildOperation newTopLevelBuildOperation(ILangOperationsListener_Default.IToolOperationMonitor opMonitor, IProject project, boolean clearMarkers, Collection2<Operation> buildCommands) throws CommonException {
        BuildOperationCreator buildOpCreator = this.createBuildOperationCreator(opMonitor, project);
        return buildOpCreator.newProjectBuildOperation(buildCommands, clearMarkers);
    }

    public static class BuildModel
    extends ProjectBasedModel<ProjectBuildInfo> {
        @Override
        protected SimpleLogger getLog() {
            return log;
        }
    }

    public static abstract class BuildType {
        protected final String name;

        public BuildType(String name) {
            this.name = (String)Assert.AssertNamespace.assertNotNull((Object)name);
        }

        public String getName() {
            return this.name;
        }

        protected BuildConfiguration getValidBuildconfiguration(String buildConfigName, BundleInfo bundleInfo) throws CommonException {
            return bundleInfo.getBuildConfiguration_nonNull(buildConfigName);
        }

        public String getDefaultCommandLine(BuildTarget bt) throws CommonException {
            return String.valueOf(VariablesResolver.variableRefString("GO_TOOL_PATH")) + " " + this.getDefaultCommandArguments(bt);
        }

        public abstract String getDefaultCommandArguments(BuildTarget var1) throws CommonException;

        public LaunchArtifact getMainLaunchArtifact(BuildTarget bt) throws CommonException {
            BuildConfiguration buildConfig = bt.getBuildConfiguration();
            if (buildConfig.getArtifactPath() == null) {
                return null;
            }
            return new LaunchArtifact(buildConfig.getName(), buildConfig.getArtifactPath());
        }

        public Indexable<LaunchArtifact> getSubTargetLaunchArtifacts(BuildTarget bt) throws CommonException {
            return null;
        }

        public abstract BuildTargetOperation getBuildOperation(BuildTargetOperation.BuildOperationParameters var1) throws CommonException;
    }
}

