/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.operations;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.utils.EclipseUtils;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.lang.tooling.common.SourceLineColumnRange;
import melnorme.lang.tooling.common.ToolSourceMessage;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.utilbox.collections.HashMap2;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.FileUtil;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.status.Severity;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class ToolMarkersHelper {
    protected boolean readWordForCharEnd;
    protected final HashMap2<Path, Document> documents = new HashMap2();

    public ToolMarkersHelper() {
        this(false);
    }

    public ToolMarkersHelper(boolean readWordForCharEnd) {
        this.readWordForCharEnd = readWordForCharEnd;
    }

    public void addErrorMarkers(Iterable<ToolSourceMessage> buildErrors, Location rootPath, IOperationMonitor om) throws CommonException {
        try {
            this.doAddErrorMarkers(buildErrors, rootPath, EclipseUtils.pm((ICancelMonitor)om));
        }
        catch (CoreException e) {
            throw EclipseUtils.createCommonException(e);
        }
    }

    public void doAddErrorMarkers(final Iterable<ToolSourceMessage> buildErrors, final Location rootPath, final IProgressMonitor pm) throws CoreException {
        this.documents.clear();
        ResourceUtils.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                for (ToolSourceMessage buildError : buildErrors) {
                    if (pm.isCanceled()) {
                        return;
                    }
                    ToolMarkersHelper.this.addErrorMarkers(buildError, rootPath);
                }
            }
        }, (ISchedulingRule)ResourceUtils.getWorkspaceRoot(), 1, pm);
    }

    public void addErrorMarkers(ToolSourceMessage toolMessage, Location rootPath) throws CoreException {
        IFile[] files;
        Location loc = rootPath.resolve(toolMessage.getFilePath());
        IFile[] iFileArray = files = ResourceUtils.getWorkspaceRoot().findFilesForLocationURI(loc.toUri());
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            this.addErrorMarker((IResource)file, toolMessage, this.getMarkerType());
            ++n2;
        }
    }

    protected String getMarkerType() {
        return "com.googlecode.goclipse.core.goProblem";
    }

    public void addErrorMarker(IResource resource, ToolSourceMessage toolMessage, String markerType) throws CoreException {
        SourceRange messageSR;
        if (!resource.exists()) {
            return;
        }
        IMarker marker = resource.createMarker(markerType);
        marker.setAttribute("severity", ToolMarkersHelper.markerSeverityFrom(toolMessage.getSeverity()));
        marker.setAttribute("message", (Object)toolMessage.getMessage());
        if (!(resource instanceof IFile)) {
            return;
        }
        IFile file = (IFile)resource;
        int line = toolMessage.getFileLineNumber();
        if (line >= 0) {
            marker.setAttribute("lineNumber", line);
        }
        SourceLineColumnRange range = toolMessage.range;
        try {
            Document doc = this.getDocumentForLocation(file);
            messageSR = this.getMessageRangeUsingDocInfo(range, (IDocument)doc);
        }
        catch (IOException e) {
            return;
        }
        if (messageSR != null) {
            try {
                marker.setAttribute("charStart", messageSR.getStartPos());
                marker.setAttribute("charEnd", messageSR.getEndPos());
            }
            catch (CoreException ce) {
                EclipseCore.logStatus(ce);
            }
        }
    }

    protected Document getDocumentForLocation(IFile file) throws IOException {
        Path filePath = file.getLocation().toFile().toPath();
        if (this.documents.containsKey((Object)filePath)) {
            return (Document)this.documents.get((Object)filePath);
        }
        String fileContents = FileUtil.readStringFromFile((Path)filePath, (Charset)StringUtil.UTF8);
        Document document = new Document(fileContents);
        this.documents.put((Object)filePath, (Object)document);
        return document;
    }

    protected SourceRange getMessageRangeUsingDocInfo(SourceLineColumnRange range, IDocument doc) {
        int charEnd;
        int charStart;
        try {
            try {
                int startLine = range.getValidLineIndex();
                int startColumn = range.getValidColumnIndex();
                charStart = doc.getLineOffset(startLine) + startColumn;
            }
            catch (CommonException ce) {
                return null;
            }
        }
        catch (BadLocationException e) {
            return null;
        }
        try {
            int endLine = range.getValidEndLineIndex();
            int endColumn = range.getValidEndColumnIndex();
            charEnd = doc.getLineOffset(endLine) + endColumn;
        }
        catch (CommonException e) {
            charEnd = this.getCharEnd(charStart, doc);
        }
        return SourceRange.srStartToEnd((int)charStart, (int)charEnd);
    }

    protected int getCharEnd(int charStart, IDocument doc) {
        if (!this.readWordForCharEnd) {
            return charStart + 1;
        }
        int ix = charStart;
        try {
            char ch = doc.getChar(++ix - 1);
            if (Character.isDigit(ch)) {
                while (Character.isDigit(doc.getChar(ix))) {
                    ++ix;
                }
            }
            if (Character.isAlphabetic(ch)) {
                while (Character.isJavaIdentifierPart(doc.getChar(ix))) {
                    ++ix;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return ix;
    }

    public static int markerSeverityFrom(Severity severity) {
        switch (severity) {
            case ERROR: {
                return 2;
            }
            case WARNING: {
                return 1;
            }
            case INFO: {
                return 0;
            }
        }
        throw Assert.AssertNamespace.assertFail();
    }
}

