/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.launch;

import melnorme.lang.ide.core.launch.BuildTargetSource;
import melnorme.lang.ide.core.operations.build.BuildTarget;
import melnorme.lang.ide.core.operations.build.BuildTargetData;
import melnorme.lang.tooling.commands.CommandInvocation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;

public abstract class CompositeBuildTargetSettings {
    protected final BuildTargetSource btSupplier;

    public CompositeBuildTargetSettings(BuildTargetSource btSupplier) {
        this.btSupplier = (BuildTargetSource)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)btSupplier)));
    }

    public abstract CommandInvocation getBuildCommand();

    public abstract String getExecutablePath();

    public BuildTargetSource getBuildTargetSupplier() {
        return this.btSupplier;
    }

    public BuildTarget getValidBuildTarget() throws CommonException {
        BuildTarget originalBuildTarget = this.btSupplier.getBuildTarget();
        return this.getValidBuildTarget2(originalBuildTarget);
    }

    protected BuildTarget getValidBuildTarget2(BuildTarget originalBuildTarget) {
        CommandInvocation buildCommand = this.getBuildCommand();
        String executablePath = this.getExecutablePath();
        BuildTargetData data = originalBuildTarget.getDataCopy();
        if (buildCommand != null) {
            data.buildCommand = buildCommand;
        }
        if (executablePath != null) {
            data.executablePath = executablePath;
        }
        return originalBuildTarget.getDerivedBuildTarget(data);
    }
}

