/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.launch;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.launch.LaunchUtils;
import melnorme.lang.ide.core.launch.ProjectLaunchSettings;
import melnorme.lang.ide.core.operations.build.BuildManager;
import melnorme.lang.ide.core.operations.build.BuildTarget;
import melnorme.lang.ide.core.operations.build.BuildTargetData;
import melnorme.lang.ide.core.operations.build.ProjectBuildInfo;
import melnorme.lang.tooling.bundle.BuildTargetNameParser;
import melnorme.lang.tooling.commands.CommandInvocation;
import melnorme.lang.tooling.commands.CommandInvocationSerializer;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.StringUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class BuildTargetLaunchCreator
extends ProjectLaunchSettings {
    protected final BuildManager buildManager = LangCore.getBuildManager();
    protected final CommandInvocationSerializer commandInvocationSerializer = new CommandInvocationSerializer();
    public BuildTargetData data = new BuildTargetData();
    public String launchNameSuffixSuggestion;

    public BuildTargetLaunchCreator() {
    }

    public BuildTargetLaunchCreator(String projectName, BuildTargetData data) {
        super(projectName);
        this.data = data;
    }

    public BuildTargetLaunchCreator(String projectName, BuildTargetData data, String launchNameSuffixSuggestion) {
        this(projectName, data);
        this.launchNameSuffixSuggestion = launchNameSuffixSuggestion;
    }

    public BuildTargetLaunchCreator(ILaunchConfiguration config) throws CoreException, CommonException {
        super(config);
        this.data.targetName = config.getAttribute("buildTarget", "");
        this.data.executablePath = LaunchUtils.getOptionalAttribute(config, "programPath_UseDefault", "programPath");
        this.data.buildCommand = (CommandInvocation)this.commandInvocationSerializer.readFromString(LaunchUtils.getOptionalAttribute(config, "buildCommand_UseDefault", "buildCommand"));
    }

    public String getTargetName() {
        return this.data.targetName;
    }

    public CommandInvocation getBuildCommand() {
        return this.data.buildCommand;
    }

    public String getExecutablePath() {
        return this.data.executablePath;
    }

    protected BuildManager getBuildManager() {
        return LangCore.getBuildManager();
    }

    @Override
    public BuildTargetLaunchCreator initFromProject(IProject project) throws CommonException {
        super.initFromProject(project);
        ProjectBuildInfo buildInfo = this.getBuildManager().getBuildInfo(project);
        if (buildInfo == null) {
            return null;
        }
        BuildTarget defaultBuildTarget = buildInfo.getDefaultBuildTarget();
        this.data.targetName = defaultBuildTarget.getTargetName();
        this.data.buildCommand = null;
        this.data.executablePath = null;
        return this;
    }

    @Override
    protected String getSuggestedConfigName_do() {
        if (this.launchNameSuffixSuggestion != null) {
            return String.valueOf(StringUtil.nullAsEmpty((String)this.projectName)) + StringUtil.prefixStr((String)" - ", (String)StringUtil.emptyAsNull((String)this.launchNameSuffixSuggestion));
        }
        String launchName = String.valueOf(StringUtil.nullAsEmpty((String)this.projectName)) + this.getSuggestedConfigName_targetSuffix();
        if (this.data.executablePath != null) {
            launchName = String.valueOf(launchName) + "[" + this.data.executablePath + "]";
        }
        return launchName;
    }

    protected String getSuggestedConfigName_targetSuffix() {
        if (StringUtil.emptyAsNull((String)this.data.targetName) == null) {
            return "";
        }
        String suggestedLabel = this.getSuggestedLabelForBuildTarget(this.data.targetName);
        if (StringUtil.emptyAsNull((String)suggestedLabel) == null) {
            return "";
        }
        return " - " + suggestedLabel;
    }

    protected String getSuggestedLabelForBuildTarget(String buildTargetName) {
        BuildTargetNameParser nameParser = this.buildManager.getBuildTargetNameParser();
        return nameParser.getBuildConfig(buildTargetName);
    }

    @Override
    protected void saveToConfig_rest(ILaunchConfigurationWorkingCopy config) throws CommonException {
        String serializedBuildCommand = this.commandInvocationSerializer.writeToString((Object)this.data.buildCommand);
        config.setAttribute("buildTarget", this.getTargetName());
        LaunchUtils.setOptionalValue(config, "buildCommand_UseDefault", "buildCommand", serializedBuildCommand);
        LaunchUtils.setOptionalValue(config, "programPath_UseDefault", "programPath", this.data.executablePath);
    }
}

