/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.engine;

import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.engine.AbstractAgentManager;
import melnorme.lang.ide.core.engine.DocumentReconcileManager;
import melnorme.lang.ide.core.engine.IStructureModelListener;
import melnorme.lang.ide.core.engine.ProblemMarkerUpdater;
import melnorme.lang.tooling.LocationKey;
import melnorme.lang.tooling.structure.SourceFileStructure;
import melnorme.lang.utils.concurrency.ConcurrentlyDerivedData;
import melnorme.lang.utils.concurrency.SynchronizedEntryMap;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.core.fntypes.CommonResult;
import melnorme.utilbox.fields.ListenerListHelper;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.ownership.IDisposable;
import melnorme.utilbox.ownership.StrictDisposable;
import org.eclipse.jface.text.IDocument;

public abstract class SourceModelManager
extends AbstractAgentManager {
    protected final DocumentReconcileManager reconcileMgr;
    protected final SynchronizedEntryMap<LocationKey, StructureInfo> infosMap = new SynchronizedEntryMap<LocationKey, StructureInfo>(){

        protected StructureInfo createEntry(LocationKey key) {
            return new StructureInfo(key);
        }
    };
    protected final ListenerListHelper<IStructureModelListener> globalListeners = new ListenerListHelper();

    public SourceModelManager() {
        this(new DocumentReconcileManager(), new ProblemMarkerUpdater());
    }

    public SourceModelManager(DocumentReconcileManager reconcileMgr, ProblemMarkerUpdater problemUpdater) {
        this.reconcileMgr = (DocumentReconcileManager)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)reconcileMgr)));
        this.asOwner().bind((IDisposable)reconcileMgr);
        if (problemUpdater != null) {
            problemUpdater.install(this);
        }
    }

    public StructureInfo getStoredStructureInfo(LocationKey key) {
        return (StructureInfo)((Object)this.infosMap.getEntryOrNull((Object)key));
    }

    public StructureModelRegistration connectStructureUpdates(LocationKey key, IDocument document, IStructureModelListener structureListener) {
        Assert.AssertNamespace.assertNotNull((Object)key);
        Assert.AssertNamespace.assertNotNull((Object)document);
        Assert.AssertNamespace.assertNotNull((Object)structureListener);
        this.log.println(new Object[]{"connectStructureUpdates: " + key});
        StructureInfo structureInfo = (StructureInfo)((Object)this.infosMap.getEntry((Object)key));
        boolean connected = structureInfo.connectDocument(document, structureListener);
        if (!connected) {
            structureInfo = new StructureInfo(key);
            connected = structureInfo.connectDocument(document, structureListener);
        }
        Assert.AssertNamespace.assertTrue((boolean)connected);
        Assert.AssertNamespace.assertTrue((boolean)CoreUtil.areEqual((Object)structureInfo.getLocation(), (Object)key.getLocation()));
        return new StructureModelRegistration(structureInfo, structureListener);
    }

    protected abstract StructureUpdateTask createUpdateTask(StructureInfo var1, String var2);

    protected StructureUpdateTask createUpdateTask_forFileSave(StructureInfo structureInfo, String source) {
        return null;
    }

    protected DisconnectUpdatesTask createDisconnectTask(StructureInfo structureInfo) {
        return new DisconnectUpdatesTask(structureInfo);
    }

    public IDisposable addListener(IStructureModelListener listener) {
        Assert.AssertNamespace.assertNotNull((Object)listener);
        this.globalListeners.addListener((Object)listener);
        return () -> this.removeListener(listener);
    }

    public void removeListener(IStructureModelListener listener) {
        this.globalListeners.removeListener((Object)listener);
    }

    public static class DisconnectUpdatesTask
    extends StructureUpdateTask {
        public DisconnectUpdatesTask(StructureInfo structureInfo) {
            super(structureInfo);
        }

        @Override
        protected SourceFileStructure doCreateNewData() throws OperationCancellation {
            Location location = this.structureInfo.getLocation();
            if (location != null) {
                this.handleDisconnectForLocation(location);
            } else {
                this.handleDisconnectForNoLocation();
            }
            throw new OperationCancellation();
        }

        protected void handleDisconnectForLocation(Location location) {
        }

        protected void handleDisconnectForNoLocation() {
        }
    }

    public class StructureInfo
    extends ConcurrentlyDerivedData<CommonResult<SourceFileStructure>, StructureInfo> {
        protected final LocationKey key2;
        protected final StructureUpdateTask disconnectTask;
        protected IDocument document = null;
        protected DocumentReconcileManager.DocumentReconcileConnection reconcileConnection = null;

        public StructureInfo(LocationKey key) {
            this.key2 = (LocationKey)Assert.AssertNamespace.assertNotNull((Object)key);
            this.disconnectTask = (StructureUpdateTask)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)SourceModelManager.this.createDisconnectTask(this))));
        }

        public final LocationKey getKey2() {
            return this.key2;
        }

        public Location getLocation() {
            return this.key2.getLocation();
        }

        protected void internalSetData(CommonResult<SourceFileStructure> newData) {
            if (newData == null) {
                newData = new CommonResult(null);
            }
            super.internalSetData(newData);
        }

        public CommonResult<SourceFileStructure> getStoredData() {
            return (CommonResult)Assert.AssertNamespace.assertNotNull((Object)((CommonResult)super.getStoredData()));
        }

        public synchronized boolean hasConnectedListeners() {
            return this.connectedListeners.getListeners().size() > 0;
        }

        protected synchronized boolean connectDocument(IDocument newDocument, IStructureModelListener listener) {
            if (this.document == null) {
                this.document = newDocument;
                this.queueSourceUpdateTask(this.document.get());
                this.reconcileConnection = SourceModelManager.this.reconcileMgr.connectDocument(this.document, this);
            } else if (this.document != newDocument) {
                return false;
            }
            this.connectedListeners.addListener((Object)listener);
            return true;
        }

        protected synchronized void disconnectFromDocument(IStructureModelListener structureListener) {
            this.connectedListeners.removeListener((Object)structureListener);
            if (!this.hasConnectedListeners()) {
                this.reconcileConnection.disconnect();
                this.reconcileConnection = null;
                this.document = null;
                this.queueUpdateTask(this.disconnectTask);
            }
        }

        protected StructureUpdateTask queueSourceUpdateTask(String source) {
            StructureUpdateTask updateTask = SourceModelManager.this.createUpdateTask(this, source);
            this.queueUpdateTask(updateTask);
            return updateTask;
        }

        public synchronized StructureUpdateTask documentSaved(IDocument document) {
            if (document != this.document) {
                return null;
            }
            StructureUpdateTask updateTask = SourceModelManager.this.createUpdateTask_forFileSave(this, document.get());
            if (updateTask != null) {
                this.queueUpdateTask(updateTask);
            }
            return updateTask;
        }

        protected synchronized void queueUpdateTask(StructureUpdateTask updateTask) {
            this.setUpdateTask(updateTask);
            SourceModelManager.this.executor.submitR((Runnable)((Object)updateTask));
        }

        protected void doHandleDataChanged() {
            super.doHandleDataChanged();
            StructureInfo.notifyStructureChanged((Object)((Object)this), SourceModelManager.this.globalListeners);
        }
    }

    public class StructureModelRegistration
    extends StrictDisposable {
        public final StructureInfo structureInfo;
        protected final IStructureModelListener structureListener;

        public StructureModelRegistration(StructureInfo structureInfo, IStructureModelListener structureListener) {
            this.structureInfo = (StructureInfo)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)structureInfo)));
            this.structureListener = (IStructureModelListener)Assert.AssertNamespace.assertNotNull((Object)structureListener);
        }

        protected void disposeDo() {
            SourceModelManager.this.log.println(new Object[]{"disconnectStructureUpdates: " + this.structureInfo.getKey2()});
            this.structureInfo.disconnectFromDocument(this.structureListener);
        }
    }

    public static abstract class StructureUpdateTask
    extends ConcurrentlyDerivedData.DataUpdateTask<CommonResult<SourceFileStructure>> {
        protected final StructureInfo structureInfo;

        public StructureUpdateTask(StructureInfo structureInfo) {
            super((ConcurrentlyDerivedData)structureInfo, structureInfo.getKey2().toString());
            this.structureInfo = structureInfo;
        }

        protected void handleRuntimeException(RuntimeException e) {
            LangCore.logInternalError(e);
        }

        protected final CommonResult<SourceFileStructure> createNewData() throws OperationCancellation {
            try {
                return new CommonResult((Object)this.doCreateNewData());
            }
            catch (CommonException e) {
                return new CommonResult(null, e);
            }
        }

        protected abstract SourceFileStructure doCreateNewData() throws CommonException, OperationCancellation;
    }
}

