/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.engine;

import melnorme.lang.ide.core.EclipseCore;
import melnorme.lang.ide.core.engine.IStructureModelListener;
import melnorme.lang.ide.core.engine.SourceModelManager;
import melnorme.lang.ide.core.operations.ToolMarkersHelper;
import melnorme.lang.ide.core.utils.CoreExecutors;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.tooling.common.ParserError;
import melnorme.lang.tooling.structure.SourceFileStructure;
import melnorme.utilbox.concurrency.ITaskAgent;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.fntypes.CommonResult;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.ownership.IDisposable;
import melnorme.utilbox.ownership.LifecycleObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class ProblemMarkerUpdater
extends LifecycleObject {
    protected SourceModelManager sourceModelManager;
    protected final ITaskAgent executor = CoreExecutors.newExecutorTaskAgent(((Object)((Object)this)).getClass());
    protected final IStructureModelListener problemUpdaterListener = new IStructureModelListener(){

        public void dataChanged(SourceModelManager.StructureInfo structureInfo) {
            UpdateProblemMarkersTask task;
            Location location = structureInfo.getLocation();
            if (location == null) {
                return;
            }
            Assert.AssertNamespace.assertTrue((Job.getJobManager().currentRule() == null ? 1 : 0) != 0);
            try {
                task = new UpdateProblemMarkersTask(structureInfo);
            }
            catch (CommonException e) {
                return;
            }
            ProblemMarkerUpdater.this.executor.submitR((Runnable)task);
        }
    };

    public void install(SourceModelManager sourceModelManager) {
        this.sourceModelManager = sourceModelManager;
        IDisposable listenerRegistration = sourceModelManager.addListener(this.problemUpdaterListener);
        this.asOwner().bind(listenerRegistration);
        sourceModelManager.asOwner().bind((IDisposable)this);
    }

    protected void dispose_post() {
        super.dispose_post();
        this.executor.shutdownNowAndCancelAll();
    }

    protected static class UpdateProblemMarkersTask
    implements Runnable {
        protected final SourceModelManager.StructureInfo structureInfo;
        protected final Location location;
        protected final SourceFileStructure structure;
        protected final CommonResult<SourceFileStructure> storedData;

        public UpdateProblemMarkersTask(SourceModelManager.StructureInfo structureInfo) throws CommonException {
            this.structureInfo = (SourceModelManager.StructureInfo)((Object)Assert.AssertNamespace.assertNotNull((Object)((Object)structureInfo)));
            this.location = (Location)Assert.AssertNamespace.assertNotNull((Object)structureInfo.getLocation());
            this.storedData = structureInfo.getStoredData();
            this.structure = (SourceFileStructure)this.storedData.get();
        }

        @Override
        public void run() {
            try {
                this.checkIsStillValid();
                this.updateProblemMarkers();
            }
            catch (CoreException ce) {
                EclipseCore.logStatus(ce);
            }
            catch (OperationCancellation e) {
                return;
            }
        }

        protected void checkIsStillValid() throws OperationCancellation {
            if (this.structureInfo.isStale(this.storedData)) {
                throw new OperationCancellation();
            }
        }

        protected void updateProblemMarkers() throws CoreException {
            IFile[] files = ResourceUtils.getWorkspaceRoot().findFilesForLocationURI(this.location.toUri());
            if (files.length == 0) {
                return;
            }
            final IFile file = files[0];
            ResourceUtils.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        this.doCreateProblemMarkers(file);
                    }
                    catch (OperationCancellation e) {
                        return;
                    }
                }
            }, (ISchedulingRule)file, 1, null);
        }

        protected void doCreateProblemMarkers(IFile file) throws CoreException, OperationCancellation {
            this.checkIsStillValid();
            if (!file.exists()) {
                return;
            }
            file.deleteMarkers("com.googlecode.goclipse.core.source_problem", true, 0);
            if (this.structure == null) {
                return;
            }
            for (ParserError problem : this.structure.getParserProblems()) {
                this.createMarker(this.location, file, problem);
            }
        }

        protected void createMarker(Location location, IFile file, ParserError problem) throws CoreException {
            IMarker marker = file.createMarker("com.googlecode.goclipse.core.source_problem");
            marker.setAttribute("location", (Object)location.toPathString());
            marker.setAttribute("message", (Object)problem.getUserMessage());
            marker.setAttribute("severity", ToolMarkersHelper.markerSeverityFrom(problem.getSeverity()));
            marker.setAttribute("charStart", problem.getStartPos());
            marker.setAttribute("charEnd", problem.getEndPos());
        }
    }
}

