/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.core.engine;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import melnorme.lang.ide.core.engine.SourceModelManager;
import melnorme.lang.ide.core.utils.CoreExecutors;
import melnorme.lang.tooling.LocationKey;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.utilbox.concurrency.ExecutorTaskAgent;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;

public abstract class EngineOperation<RET> {
    protected final SourceModelManager sourceModelMgr;
    protected final Location location;
    protected final int offset;
    protected final int timeoutMillis;
    protected final String opName;

    public EngineOperation(SourceModelManager sourceModelMgr, Location location, int offset, int timeoutMillis, String opName) {
        this.sourceModelMgr = sourceModelMgr;
        this.location = location;
        this.offset = offset;
        this.timeoutMillis = timeoutMillis;
        this.opName = (String)Assert.AssertNamespace.assertNotNull((Object)opName);
    }

    public RET runEngineOperation(IOperationMonitor om) throws CommonException, OperationCancellation {
        if (this.timeoutMillis <= 0) {
            return this.doRunEngineOperation(om);
        }
        ExecutorTaskAgent completionExecutor = CoreExecutors.newExecutorTaskAgent(String.valueOf(this.opName) + " - Task Executor");
        try {
            RET RET = this.runEngineOperationWithExecutor(om, completionExecutor);
            return RET;
        }
        finally {
            completionExecutor.shutdownNow();
        }
    }

    protected RET runEngineOperationWithExecutor(final IOperationMonitor om, ExecutorTaskAgent completionExecutor) throws CommonException, OperationCancellation {
        Future future = completionExecutor.submit(new Callable<RET>(){

            @Override
            public RET call() throws CommonException, OperationCancellation {
                return EngineOperation.this.doRunEngineOperation(om);
            }
        });
        try {
            return (RET)future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof OperationCancellation) {
                throw (OperationCancellation)e.getCause();
            }
            if (e.getCause() instanceof CommonException) {
                throw (CommonException)e.getCause();
            }
            throw new CommonException("Error performing " + this.opName + ".", e.getCause());
        }
        catch (TimeoutException e) {
            throw new CommonException("Timeout performing " + this.opName + ".", null);
        }
        catch (InterruptedException e) {
            throw new CommonException("Interrupted.", (Throwable)e);
        }
    }

    protected RET doRunEngineOperation(IOperationMonitor om) throws CommonException, OperationCancellation {
        SourceModelManager.StructureInfo structureInfo = this.sourceModelMgr.getStoredStructureInfo(new LocationKey(this.location));
        if (structureInfo != null) {
            structureInfo.awaitUpdatedData(om);
        }
        return this.doRunOperationWithWorkingCopy(om);
    }

    protected abstract RET doRunOperationWithWorkingCopy(IOperationMonitor var1) throws CommonException, OperationCancellation;
}

